/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.bitpacking;

public class LongPacker {
    private static final int NUM_OF_LONGS = 8;
    private int width;

    public LongPacker(int width) {
        this.width = width;
    }

    public void pack8Values(long[] values, int offset, byte[] buf) {
        int bufIdx = 0;
        int valueIdx = offset;
        int leftBit = 0;
        while (valueIdx < 8 + offset) {
            long buffer = 0L;
            int leftSize = 64;
            if (leftBit > 0) {
                buffer |= values[valueIdx] << 64 - leftBit;
                leftSize -= leftBit;
                leftBit = 0;
                ++valueIdx;
            }
            while (leftSize >= this.width && valueIdx < 8 + offset) {
                buffer |= values[valueIdx] << leftSize - this.width;
                leftSize -= this.width;
                ++valueIdx;
            }
            if (leftSize > 0 && valueIdx < 8 + offset) {
                buffer |= values[valueIdx] >>> this.width - leftSize;
                leftBit = this.width - leftSize;
            }
            for (int j = 0; j < 8; ++j) {
                buf[bufIdx] = (byte)(buffer >>> (8 - j - 1) * 8 & 0xFFL);
                if (++bufIdx < this.width * 8 / 8) continue;
                return;
            }
        }
    }

    public void unpack8Values(byte[] buf, int offset, long[] values) {
        int byteIdx = offset;
        int leftBits = 8;
        int totalBits = 0;
        for (int valueIdx = 0; valueIdx < 8; ++valueIdx) {
            values[valueIdx] = 0L;
            while (totalBits < this.width) {
                if (this.width - totalBits >= leftBits) {
                    values[valueIdx] = values[valueIdx] << leftBits;
                    values[valueIdx] = values[valueIdx] | (1L << leftBits) - 1L & (long)buf[byteIdx];
                    totalBits += leftBits;
                    ++byteIdx;
                    leftBits = 8;
                    continue;
                }
                int t = this.width - totalBits;
                values[valueIdx] = values[valueIdx] << t;
                values[valueIdx] = values[valueIdx] | ((1L << leftBits) - 1L & (long)buf[byteIdx]) >>> leftBits - t;
                leftBits -= t;
                totalBits += t;
            }
            totalBits = 0;
        }
    }

    public void unpackAllValues(byte[] buf, int length, long[] values) {
        int idx = 0;
        int k = 0;
        while (idx < length) {
            long[] tv = new long[8];
            this.unpack8Values(buf, idx, tv);
            System.arraycopy(tv, 0, values, k, 8);
            idx += this.width;
            k += 8;
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

