/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class NodeAttributes
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=349");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=351");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=350");
    private final UInteger specifiedAttributes;
    private final LocalizedText displayName;
    private final LocalizedText description;
    private final UInteger writeMask;
    private final UInteger userWriteMask;

    public NodeAttributes(UInteger specifiedAttributes, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        this.specifiedAttributes = specifiedAttributes;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UInteger getSpecifiedAttributes() {
        return this.specifiedAttributes;
    }

    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public UInteger getWriteMask() {
        return this.writeMask;
    }

    public UInteger getUserWriteMask() {
        return this.userWriteMask;
    }

    protected NodeAttributes(NodeAttributesBuilder<?, ?> b) {
        super(b);
        this.specifiedAttributes = ((NodeAttributesBuilder)b).specifiedAttributes;
        this.displayName = ((NodeAttributesBuilder)b).displayName;
        this.description = ((NodeAttributesBuilder)b).description;
        this.writeMask = ((NodeAttributesBuilder)b).writeMask;
        this.userWriteMask = ((NodeAttributesBuilder)b).userWriteMask;
    }

    public static NodeAttributesBuilder<?, ?> builder() {
        return new NodeAttributesBuilderImpl();
    }

    public NodeAttributesBuilder<?, ?> toBuilder() {
        return new NodeAttributesBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeAttributes)) {
            return false;
        }
        NodeAttributes other = (NodeAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$specifiedAttributes = this.getSpecifiedAttributes();
        UInteger other$specifiedAttributes = other.getSpecifiedAttributes();
        if (this$specifiedAttributes == null ? other$specifiedAttributes != null : !((Object)this$specifiedAttributes).equals(other$specifiedAttributes)) {
            return false;
        }
        LocalizedText this$displayName = this.getDisplayName();
        LocalizedText other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !((Object)this$displayName).equals(other$displayName)) {
            return false;
        }
        LocalizedText this$description = this.getDescription();
        LocalizedText other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        UInteger this$writeMask = this.getWriteMask();
        UInteger other$writeMask = other.getWriteMask();
        if (this$writeMask == null ? other$writeMask != null : !((Object)this$writeMask).equals(other$writeMask)) {
            return false;
        }
        UInteger this$userWriteMask = this.getUserWriteMask();
        UInteger other$userWriteMask = other.getUserWriteMask();
        return !(this$userWriteMask == null ? other$userWriteMask != null : !((Object)this$userWriteMask).equals(other$userWriteMask));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeAttributes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $specifiedAttributes = this.getSpecifiedAttributes();
        result = result * 59 + ($specifiedAttributes == null ? 43 : ((Object)$specifiedAttributes).hashCode());
        LocalizedText $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : ((Object)$displayName).hashCode());
        LocalizedText $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        UInteger $writeMask = this.getWriteMask();
        result = result * 59 + ($writeMask == null ? 43 : ((Object)$writeMask).hashCode());
        UInteger $userWriteMask = this.getUserWriteMask();
        result = result * 59 + ($userWriteMask == null ? 43 : ((Object)$userWriteMask).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NodeAttributes(specifiedAttributes=" + this.getSpecifiedAttributes() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", writeMask=" + this.getWriteMask() + ", userWriteMask=" + this.getUserWriteMask() + ")";
    }

    private static final class NodeAttributesBuilderImpl
    extends NodeAttributesBuilder<NodeAttributes, NodeAttributesBuilderImpl> {
        private NodeAttributesBuilderImpl() {
        }

        @Override
        protected NodeAttributesBuilderImpl self() {
            return this;
        }

        @Override
        public NodeAttributes build() {
            return new NodeAttributes(this);
        }
    }

    public static abstract class NodeAttributesBuilder<C extends NodeAttributes, B extends NodeAttributesBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger specifiedAttributes;
        private LocalizedText displayName;
        private LocalizedText description;
        private UInteger writeMask;
        private UInteger userWriteMask;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            NodeAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(NodeAttributes instance, NodeAttributesBuilder<?, ?> b) {
            b.specifiedAttributes(instance.specifiedAttributes);
            b.displayName(instance.displayName);
            b.description(instance.description);
            b.writeMask(instance.writeMask);
            b.userWriteMask(instance.userWriteMask);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B specifiedAttributes(UInteger specifiedAttributes) {
            this.specifiedAttributes = specifiedAttributes;
            return (B)this.self();
        }

        public B displayName(LocalizedText displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        public B description(LocalizedText description) {
            this.description = description;
            return (B)this.self();
        }

        public B writeMask(UInteger writeMask) {
            this.writeMask = writeMask;
            return (B)this.self();
        }

        public B userWriteMask(UInteger userWriteMask) {
            this.userWriteMask = userWriteMask;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "NodeAttributes.NodeAttributesBuilder(super=" + super.toString() + ", specifiedAttributes=" + this.specifiedAttributes + ", displayName=" + this.displayName + ", description=" + this.description + ", writeMask=" + this.writeMask + ", userWriteMask=" + this.userWriteMask + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<NodeAttributes> {
        @Override
        public Class<NodeAttributes> getType() {
            return NodeAttributes.class;
        }

        @Override
        public NodeAttributes decode(SerializationContext context, UaDecoder decoder) {
            UInteger specifiedAttributes = decoder.readUInt32("SpecifiedAttributes");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            return new NodeAttributes(specifiedAttributes, displayName, description, writeMask, userWriteMask);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, NodeAttributes value) {
            encoder.writeUInt32("SpecifiedAttributes", value.getSpecifiedAttributes());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
        }
    }
}

