/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.binaryallocator.metric;

import org.apache.iotdb.commons.binaryallocator.BinaryAllocator;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class BinaryAllocatorMetrics
implements IMetricSet {
    private static final String TOTAL_MEMORY = "total-memory";
    private static final String ALLOCATE_FROM_SLAB = "allocate-from-slab";
    private static final String ALLOCATE_FROM_JVM = "allocate-from-jvm";
    private static final String ACTIVE_MEMORY = "active-memory";
    private static final String EVICTED_BY_SAMPLE_EVICTION = "evicted-by-sample-eviction";
    private static final String EVICTED_BY_GC_EVICTION = "evicted-by-gc-eviction";
    private final BinaryAllocator binaryAllocator;
    private Counter allocateFromSlab;
    private Counter allocateFromJVM;
    private Counter evictedBySampleEviction;
    private Counter evictedByGcEviction;

    public BinaryAllocatorMetrics(BinaryAllocator binaryAllocator) {
        this.binaryAllocator = binaryAllocator;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.BINARY_ALLOCATOR.toString(), MetricLevel.IMPORTANT, (Object)this.binaryAllocator, BinaryAllocator::getTotalUsedMemory, new String[]{Tag.NAME.toString(), TOTAL_MEMORY});
        metricService.createAutoGauge(Metric.BINARY_ALLOCATOR.toString(), MetricLevel.IMPORTANT, (Object)this.binaryAllocator, BinaryAllocator::getTotalActiveMemory, new String[]{Tag.NAME.toString(), ACTIVE_MEMORY});
        this.allocateFromSlab = metricService.getOrCreateCounter(Metric.BINARY_ALLOCATOR.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), ALLOCATE_FROM_SLAB});
        this.allocateFromJVM = metricService.getOrCreateCounter(Metric.BINARY_ALLOCATOR.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), ALLOCATE_FROM_JVM});
        this.evictedBySampleEviction = metricService.getOrCreateCounter(Metric.BINARY_ALLOCATOR.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), EVICTED_BY_SAMPLE_EVICTION});
        this.evictedByGcEviction = metricService.getOrCreateCounter(Metric.BINARY_ALLOCATOR.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), EVICTED_BY_GC_EVICTION});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.BINARY_ALLOCATOR.toString(), new String[]{Tag.NAME.toString(), TOTAL_MEMORY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.BINARY_ALLOCATOR.toString(), new String[]{Tag.NAME.toString(), ACTIVE_MEMORY});
        metricService.remove(MetricType.COUNTER, Metric.BINARY_ALLOCATOR.toString(), new String[]{Tag.NAME.toString(), ALLOCATE_FROM_SLAB});
        metricService.remove(MetricType.COUNTER, Metric.BINARY_ALLOCATOR.toString(), new String[]{Tag.NAME.toString(), ALLOCATE_FROM_JVM});
        metricService.remove(MetricType.COUNTER, Metric.BINARY_ALLOCATOR.toString(), new String[]{Tag.NAME.toString(), EVICTED_BY_SAMPLE_EVICTION});
        metricService.remove(MetricType.COUNTER, Metric.BINARY_ALLOCATOR.toString(), new String[]{Tag.NAME.toString(), EVICTED_BY_GC_EVICTION});
    }

    public void updateAllocationCounter(long allocateFromSlabDelta, long allocateFromJVMDelta) {
        this.allocateFromSlab.inc(allocateFromSlabDelta);
        this.allocateFromJVM.inc(allocateFromJVMDelta);
    }

    public void updateGcEvictionCounter(long evictedByGcEvictionDelta) {
        this.evictedByGcEviction.inc(evictedByGcEvictionDelta);
    }

    public void updateSampleEvictionCounter(long evictedBySampleEvictionDelta) {
        this.evictedBySampleEviction.inc(evictedBySampleEvictionDelta);
    }
}

