/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycle {
    public static final Logger LOG = LoggerFactory.getLogger(LifeCycle.class);
    private volatile String name;
    private final AtomicReference<State> current = new AtomicReference<State>(State.NEW);

    public LifeCycle(Object name) {
        this.name = name.toString();
        LOG.debug("{}: {}", name, this.current);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void transition(State to) {
        this.current.updateAndGet(from -> {
            State.validate(this.name, from, to);
            return to;
        });
    }

    public void transitionIfNotEqual(State to) {
        this.current.updateAndGet(from -> {
            if (from != to) {
                State.validate(this.name, from, to);
            }
            return to;
        });
    }

    public boolean transitionIfValid(State to) {
        State updated = this.current.updateAndGet(from -> State.isValid(from, to) ? to : from);
        return updated == to;
    }

    public State transition(UnaryOperator<State> operator) {
        State applied;
        State previous;
        do {
            if ((previous = this.current.get()) == (applied = (State)((Object)operator.apply(previous)))) {
                return null;
            }
            State.validate(this.name, previous, applied);
        } while (!this.current.compareAndSet(previous, applied));
        return applied;
    }

    public State transitionAndGet(UnaryOperator<State> operator) {
        return this.current.updateAndGet(previous -> {
            State applied = (State)((Object)((Object)operator.apply((State)((Object)previous))));
            if (applied != previous) {
                State.validate(this.name, previous, applied);
            }
            return applied;
        });
    }

    public boolean compareAndTransition(State from, State to) {
        State previous = this.current.getAndUpdate(state -> {
            if (state != from) {
                return state;
            }
            State.validate(this.name, from, to);
            return to;
        });
        return previous == from;
    }

    public State getCurrentState() {
        return this.current.get();
    }

    public void assertCurrentState(Set<State> expected) {
        this.assertCurrentState((n, c) -> new IllegalStateException("STATE MISMATCHED: In " + n + ", current state " + (Object)c + " is not one of the expected states " + expected), expected);
    }

    public <T extends Throwable> State assertCurrentState(BiFunction<String, State, T> newThrowable, Set<State> expected) throws T {
        State c = this.getCurrentState();
        if (!expected.contains((Object)c)) {
            throw (Throwable)newThrowable.apply(this.name, c);
        }
        return c;
    }

    public String toString() {
        return this.name + ":" + (Object)((Object)this.getCurrentState());
    }

    @SafeVarargs
    public final <T extends Throwable> void startAndTransition(CheckedRunnable<T> startImpl, Class<? extends Throwable> ... exceptionClasses) throws T {
        this.transition(State.STARTING);
        try {
            startImpl.run();
            this.transition(State.RUNNING);
        }
        catch (Throwable t) {
            this.transition(ReflectionUtils.isInstance(t, exceptionClasses) ? State.NEW : State.EXCEPTION);
            throw t;
        }
    }

    public State checkStateAndClose() {
        return this.checkStateAndClose(() -> State.CLOSING);
    }

    public <T extends Throwable> State checkStateAndClose(CheckedRunnable<T> closeMethod) throws T {
        return this.checkStateAndClose(() -> {
            try {
                closeMethod.run();
            }
            finally {
                this.transition(State.CLOSED);
            }
            return State.CLOSED;
        });
    }

    private <T extends Throwable> State checkStateAndClose(CheckedSupplier<State, T> closeMethod) throws T {
        State c;
        if (this.compareAndTransition(State.NEW, State.CLOSED)) {
            return State.CLOSED;
        }
        do {
            if (!(c = this.getCurrentState()).isClosingOrClosed()) continue;
            return c;
        } while (!this.compareAndTransition(c, State.CLOSING));
        return closeMethod.get();
    }

    public static final class States {
        public static final Set<State> RUNNING = Collections.unmodifiableSet(EnumSet.of(State.RUNNING));
        public static final Set<State> STARTING_OR_RUNNING = Collections.unmodifiableSet(EnumSet.of(State.STARTING, State.RUNNING));
        public static final Set<State> CLOSING_OR_CLOSED = Collections.unmodifiableSet(EnumSet.of(State.CLOSING, State.CLOSED));
        public static final Set<State> PAUSING_OR_PAUSED = Collections.unmodifiableSet(EnumSet.of(State.PAUSING, State.PAUSED));
        public static final Set<State> CLOSING_OR_CLOSED_OR_EXCEPTION = Collections.unmodifiableSet(EnumSet.of(State.CLOSING, State.CLOSED, State.EXCEPTION));

        private States() {
        }
    }

    public static enum State {
        NEW,
        STARTING,
        RUNNING,
        PAUSING,
        PAUSED,
        EXCEPTION,
        CLOSING,
        CLOSED;

        private static final Map<State, List<State>> PREDECESSORS;

        public boolean isRunning() {
            return this == RUNNING;
        }

        public boolean isClosingOrClosed() {
            return States.CLOSING_OR_CLOSED.contains((Object)this);
        }

        public boolean isPausingOrPaused() {
            return States.PAUSING_OR_PAUSED.contains((Object)this);
        }

        static void put(State key, Map<State, List<State>> map, State ... values) {
            map.put(key, Collections.unmodifiableList(Arrays.asList(values)));
        }

        public static boolean isValid(State from, State to) {
            return PREDECESSORS.get((Object)to).contains((Object)from);
        }

        static void validate(Object name, State from, State to) {
            LOG.debug("{}: {} -> {}", new Object[]{name, from, to});
            if (LOG.isTraceEnabled()) {
                LOG.trace("TRACE", new Throwable());
            }
            Preconditions.assertTrue(State.isValid(from, to), "ILLEGAL TRANSITION: In %s, %s -> %s", new Object[]{name, from, to});
        }

        static {
            EnumMap<State, List<State>> predecessors = new EnumMap<State, List<State>>(State.class);
            State.put(NEW, predecessors, STARTING);
            State.put(STARTING, predecessors, NEW, PAUSED);
            State.put(RUNNING, predecessors, STARTING);
            State.put(PAUSING, predecessors, RUNNING);
            State.put(PAUSED, predecessors, PAUSING);
            State.put(EXCEPTION, predecessors, STARTING, PAUSING, RUNNING);
            State.put(CLOSING, predecessors, STARTING, RUNNING, PAUSING, PAUSED, EXCEPTION);
            State.put(CLOSED, predecessors, NEW, CLOSING);
            PREDECESSORS = Collections.unmodifiableMap(predecessors);
        }
    }
}

