"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportArtifactTypes = void 0;
exports.parseApiContent = parseApiContent;
var yaml = require("js-yaml");
var path_browserify_1 = require("path-browserify");
var api_1 = require("../../api");
var AsyncApiParser_1 = require("./impl/asyncapi/AsyncApiParser");
var JsonSchemaParser_1 = require("./impl/jsonschema/JsonSchemaParser");
var OpenApiParser_1 = require("./impl/openapi/OpenApiParser");
var CamelRoutesParser_1 = require("./impl/camelRoutes/CamelRoutesParser");
var specParsers = [
    new OpenApiParser_1.OpenApiParser(),
    new AsyncApiParser_1.AsyncApiParser(),
    new JsonSchemaParser_1.JsonSchemaParser(),
    new CamelRoutesParser_1.CamelRoutesParser(),
];
exports.supportArtifactTypes = [
    api_1.SupportArtifactTypes.Openapi,
    api_1.SupportArtifactTypes.Asyncapi,
];
function parseApiContent(args) {
    return serviceFileContentToApiDocument(args);
}
function serviceFileContentToApiDocument(args) {
    var specContent;
    if (path_browserify_1.posix.extname(args.serviceFileName) === ".json") {
        specContent = JSON.parse(args.serviceFileContent);
    }
    else {
        specContent = yaml.load(args.serviceFileContent);
    }
    var parser = specContent && specParsers.find(function (parser) { return parser.canParse(specContent); });
    if (!parser) {
        throw new Error("'".concat(args.serviceFileName, "' is not a supported spec file"));
    }
    return parser.parse(specContent, args);
}
//# sourceMappingURL=parseApiContent.js.map