import { BrowserComponentBus } from "./controller/BrowserComponentBus";
import { DashbuilderComponentController } from "./controller/DashbuilderComponentController";
import { DashbuilderComponentDispatcher } from "./controller/DashbuilderComponentDispatcher";
export class ComponentApi {
    constructor() {
        this.bus = new BrowserComponentBus();
        this.controller = new DashbuilderComponentController(this.bus);
        this.listener = new DashbuilderComponentDispatcher(this.bus, this.controller);
        this.listener.init();
    }
    getComponentController(onInit, onDataSet) {
        if (onInit) {
            this.controller.setOnInit(onInit);
        }
        if (onDataSet) {
            this.controller.setOnDataSet(onDataSet);
        }
        return this.controller;
    }
    restart() {
        this.destroy();
        this.listener.init();
    }
    destroy() {
        this.listener.stop();
    }
}
//# sourceMappingURL=ComponentApi.js.map