import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useImperativeHandle, useState } from "react";
import WorkflowList from "./components/WorkflowList/WorkflowList";
import WorkflowListEnvelopeViewDriver from "./WorkflowListEnvelopeViewDriver";
export const WorkflowListEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [workflowInitialState, setWorkflowInitialState] = useState({});
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initialState) => {
            setEnvelopeConnectedToChannel(false);
            setWorkflowInitialState(initialState);
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (_jsx(React.Fragment, { children: _jsx(WorkflowList, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new WorkflowListEnvelopeViewDriver(props.channelApi), initialState: workflowInitialState.initialState }) }));
});
export default WorkflowListEnvelopeView;
//# sourceMappingURL=WorkflowListEnvelopeView.js.map