import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { getActionColumn, getColumn } from "../utils/WorkflowDefinitionListUtils";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import WorkflowDefinitionListToolbar from "../WorkflowDefinitionListToolbar/WorkflowDefinitionListToolbar";
const WorkflowDefinitionList = ({ isEnvelopeConnectedToChannel, driver, ouiaId, ouiaSafe, }) => {
    const [workflowDefinitionList, setWorkflowDefinitionList] = useState([]);
    const [isLoading, setIsLoading] = useState(true);
    const [filterWorkflowNames, setFilterWorkflowNames] = useState([]);
    const [error, setError] = useState();
    const doQuery = async () => {
        try {
            const response = await driver.getWorkflowDefinitionsQuery();
            setWorkflowDefinitionList(response);
            setIsLoading(false);
        }
        catch (err) {
            setError(err.errorMessage);
        }
        finally {
            setIsLoading(false);
        }
    };
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        init();
        return () => {
            setFilterWorkflowNames([]);
        };
    }, [isEnvelopeConnectedToChannel]);
    const init = async () => {
        doQuery();
    };
    const columns = [
        getColumn("workflowName", `Workflow Name`),
        getColumn("endpoint", "Endpoint"),
        getActionColumn((workflowDefinition) => {
            driver.openWorkflowForm(workflowDefinition);
        }, (workflowDefinition) => {
            driver.openTriggerCloudEvent(workflowDefinition);
        }),
    ];
    const applyFilter = async () => {
        await driver.setWorkflowDefinitionFilter(filterWorkflowNames);
    };
    const doRefresh = async () => {
        setIsLoading(true);
        doQuery();
    };
    const filterWorkflowDefinition = () => {
        if (filterWorkflowNames.length === 0) {
            return workflowDefinitionList;
        }
        return workflowDefinitionList.filter((workflowDefinition) => {
            return filterWorkflowNames.some((filter) => workflowDefinition.workflowName.includes(filter));
        });
    };
    const workflowDefinitionLoadingComponent = (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: `Loading workflow definitions...`, ouiaId: "forms-list-loading-workflow-definitions" }) }));
    if (error) {
        return _jsx(ServerErrors, { error: error, variant: "large" });
    }
    return (_jsxs("div", { ...componentOuiaProps(ouiaId, "workflow-definition-list", ouiaSafe ? ouiaSafe : !isLoading), children: [_jsx(WorkflowDefinitionListToolbar, { filterWorkflowNames: filterWorkflowNames, setFilterWorkflowNames: setFilterWorkflowNames, applyFilter: applyFilter, doRefresh: doRefresh }), _jsx(Divider, {}), _jsx(DataTable, { data: filterWorkflowDefinition(), isLoading: isLoading, columns: columns, error: false, LoadingComponent: workflowDefinitionLoadingComponent })] }));
};
export default WorkflowDefinitionList;
//# sourceMappingURL=WorkflowDefinitionList.js.map