import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { BulkWorkflowInstanceActionResponse, WorkflowInstance, WorkflowInstanceFilter, WorkflowListSortBy } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { ApolloClient } from "apollo-client";
export interface WorkflowListQueries {
    getWorkflowInstances(start: number, end: number, filters: WorkflowInstanceFilter, sortBy: WorkflowListSortBy): Promise<WorkflowInstance[]>;
    getChildWorkflowInstances(rootWorkflowInstanceId: string): Promise<WorkflowInstance[]>;
    handleWorkflowSkip(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowAbort(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowRetry(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowMultipleAction(workflowInstances: WorkflowInstance[], operationType: OperationType): Promise<BulkWorkflowInstanceActionResponse>;
}
export declare class GraphQLWorkflowListQueries implements WorkflowListQueries {
    private readonly client;
    constructor(client: ApolloClient<any>);
    getWorkflowInstances(offset: number, limit: number, filters: WorkflowInstanceFilter, sortBy: WorkflowListSortBy): Promise<WorkflowInstance[]>;
    getChildWorkflowInstances(rootWorkflowInstanceId: string): Promise<WorkflowInstance[]>;
    handleWorkflowSkip(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowAbort(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowRetry(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowMultipleAction(workflowInstances: WorkflowInstance[], operationType: OperationType): Promise<BulkWorkflowInstanceActionResponse>;
}
//# sourceMappingURL=WorkflowListQueries.d.ts.map