import { NodeInstance, TriggerableNode } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { Job, JobCancel, WorkflowInstance } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { ApolloClient } from "apollo-client";
export interface WorkflowDetailsQueries {
    getWorkflowDetails(id: string): Promise<WorkflowInstance>;
    getJobs(id: string): Promise<Job[]>;
    handleWorkflowSkip(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowAbort(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowRetry(workflowInstance: WorkflowInstance): Promise<void>;
    jobCancel(job: Job): Promise<JobCancel>;
    rescheduleJob: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(workflowInstance: WorkflowInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(workflowInstance: WorkflowInstance, node: any): Promise<void>;
    handleWorkflowVariableUpdate: (workflowInstance: WorkflowInstance, updateJson: Record<string, unknown>) => Promise<Record<string, unknown>>;
    handleNodeInstanceCancel: (workflowInstance: WorkflowInstance, node: NodeInstance) => Promise<void>;
    handleNodeInstanceRetrigger(workflowInstance: WorkflowInstance, node: NodeInstance): Promise<void>;
}
export declare class GraphQLWorkflowDetailsQueries implements WorkflowDetailsQueries {
    private readonly client;
    constructor(client: ApolloClient<any>);
    getWorkflowDetails(id: string): Promise<WorkflowInstance>;
    getJobs(id: string): Promise<Job[]>;
    handleWorkflowSkip(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowAbort(workflowInstance: WorkflowInstance): Promise<void>;
    handleWorkflowRetry(workflowInstance: WorkflowInstance): Promise<void>;
    jobCancel(job: Job): Promise<JobCancel>;
    rescheduleJob(job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date): Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(workflowInstance: WorkflowInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(workflowInstance: WorkflowInstance, node: any): Promise<void>;
    handleNodeInstanceCancel(workflowInstance: WorkflowInstance, node: NodeInstance): Promise<void>;
    handleWorkflowVariableUpdate(workflowInstance: WorkflowInstance, updateJson: Record<string, unknown>): Promise<Record<string, unknown>>;
    handleNodeInstanceRetrigger(workflowInstance: WorkflowInstance, node: NodeInstance): Promise<void>;
}
//# sourceMappingURL=WorkflowDetailsQueries.d.ts.map