import { useCallback, useEffect, useRef, useState } from "react";
export function useConnectedEnvelopeServer(envelopeServer, apiImpl) {
    useEffect(() => {
        const listener = (msg) => envelopeServer.receive(msg.data, apiImpl);
        window.addEventListener("message", listener, false);
        envelopeServer.startInitPolling(apiImpl);
        return () => {
            envelopeServer.stopInitPolling();
            window.removeEventListener("message", listener);
        };
    }, [envelopeServer, apiImpl]);
}
export function useSubscription(notificationConsumer, callback) {
    useEffect(() => {
        const subscription = notificationConsumer.subscribe(callback);
        return () => {
            notificationConsumer.unsubscribe(subscription);
        };
    }, [notificationConsumer, callback]);
}
export function useSubscriptionOnce(notificationConsumer, callback) {
    useEffect(() => {
        let unsubscribed = false;
        const subscription = notificationConsumer.subscribe((...args) => {
            callback(...args);
            unsubscribed = true;
            notificationConsumer.unsubscribe(subscription);
        });
        return () => {
            if (!unsubscribed) {
                notificationConsumer.unsubscribe(subscription);
            }
        };
    }, [callback, notificationConsumer]);
}
export function useSharedValue(sharedValue) {
    const [value, setValue] = useState();
    useEffect(() => {
        if (!sharedValue) {
            return;
        }
        const subscription = sharedValue.subscribe((newValue) => setValue(newValue));
        return () => sharedValue.unsubscribe(subscription);
    }, [sharedValue]);
    const sharedValueRef = useRef(sharedValue);
    const ret__setValue = useCallback((t) => {
        var _a;
        (_a = sharedValueRef.current) === null || _a === void 0 ? void 0 : _a.set(t);
    }, []);
    useEffect(() => {
        sharedValueRef.current = sharedValue;
    }, [sharedValue]);
    return [value, ret__setValue];
}
export function useStateAsSharedValue(value, setValue, sharedValue) {
    useEffect(() => {
        if (!sharedValue) {
            return;
        }
        const subscription = sharedValue.subscribe((newValue) => setValue(newValue));
        return () => sharedValue.unsubscribe(subscription);
    }, [sharedValue, setValue]);
    useEffect(() => {
        sharedValue === null || sharedValue === void 0 ? void 0 : sharedValue.set(value);
    }, [sharedValue, value]);
}
//# sourceMappingURL=Hooks.js.map