import { EnvelopeBusMessageDirectSender, EnvelopeBusMessagePurpose, } from "../api";
import { EnvelopeBusMessageManager } from "../common";
export var EnvelopeServerType;
(function (EnvelopeServerType) {
    EnvelopeServerType["LOCAL"] = "local";
    EnvelopeServerType["REMOTE"] = "remote";
})(EnvelopeServerType || (EnvelopeServerType = {}));
export class EnvelopeServer {
    get envelopeApi() {
        return this.manager.clientApi;
    }
    get shared() {
        return this.manager.shared;
    }
    constructor(bus, origin, pollInit, type = EnvelopeServerType.REMOTE, manager = new EnvelopeBusMessageManager((message) => bus.postMessage({
        ...message,
        targetEnvelopeId: type === EnvelopeServerType.LOCAL ? this.id : undefined,
        directSender: EnvelopeBusMessageDirectSender.ENVELOPE_SERVER,
    }), "EnvelopeServer")) {
        this.origin = origin;
        this.pollInit = pollInit;
        this.type = type;
        this.manager = manager;
        this.id = this.generateRandomId();
    }
    startInitPolling(apiImpl) {
        this.pollInit(this).then(() => {
            this.stopInitPolling();
        });
        this.manager.currentApiImpl = apiImpl;
        this.initialPollingSetting = setTimeout(() => {
            this.initPolling = setInterval(() => {
                this.pollInit(this).then(() => this.stopInitPolling());
            }, EnvelopeServer.INIT_POLLING_INTERVAL_IN_MS);
            this.initPollingTimeout = setTimeout(() => {
                this.stopInitPolling();
                console.info("Init polling timed out. Looks like the Envelope is not responding accordingly.");
            }, EnvelopeServer.INIT_POLLING_TIMEOUT_IN_MS);
        }, EnvelopeServer.INIT_POLLING_INTERVAL_IN_MS);
    }
    stopInitPolling() {
        clearTimeout(this.initialPollingSetting);
        this.initialPollingSetting = undefined;
        this.manager.currentApiImpl = undefined;
        clearInterval(this.initPolling);
        this.initPolling = undefined;
        clearTimeout(this.initPollingTimeout);
        this.initPollingTimeout = undefined;
    }
    receive(message, apiImpl) {
        if (message.directSender === EnvelopeBusMessageDirectSender.ENVELOPE_SERVER) {
            return;
        }
        if (message.targetEnvelopeId) {
            return;
        }
        if (message.targetEnvelopeServerId === this.id) {
            this.manager.server.receive(message, apiImpl);
        }
        else if (message.purpose === EnvelopeBusMessagePurpose.NOTIFICATION) {
            this.manager.server.receive(message, {});
        }
    }
    generateRandomId() {
        const randomPart = Math.random().toString(36).substr(2, 9);
        const milliseconds = new Date().getMilliseconds();
        return `_${randomPart}_${milliseconds}`;
    }
}
EnvelopeServer.INIT_POLLING_TIMEOUT_IN_MS = 60000;
EnvelopeServer.INIT_POLLING_INTERVAL_IN_MS = 100;
//# sourceMappingURL=EnvelopeServer.js.map