"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.positions_equals = exports.EditorLanguageService = void 0;
exports.findNodeAtLocation = findNodeAtLocation;
exports.findNodeAtOffset = findNodeAtOffset;
exports.getNodePath = getNodePath;
var jsonc = require("jsonc-parser");
var vscode_languageserver_textdocument_1 = require("vscode-languageserver-textdocument");
var findNodesAtLocation_1 = require("./findNodesAtLocation");
var refValidation_1 = require("./refValidation");
var EditorLanguageService = (function () {
    function EditorLanguageService(args) {
        this.args = args;
    }
    EditorLanguageService.prototype.getCompletionItems = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var doc, cursorOffset, getEmptyFileCodeCompletions, currentNode, currentNodeRange, overwriteRange, matchedCompletions, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        doc = vscode_languageserver_textdocument_1.TextDocument.create(args.uri, this.args.lang.fileLanguage, 0, args.content);
                        cursorOffset = doc.offsetAt(args.cursorPosition);
                        if (!args.rootNode) {
                            getEmptyFileCodeCompletions = args.completions.get(null);
                            return [2, args.content.trim().length || !getEmptyFileCodeCompletions
                                    ? []
                                    : getEmptyFileCodeCompletions(__assign(__assign({}, args), { cursorOffset: cursorOffset, document: doc }))];
                        }
                        currentNode = findNodeAtOffset(args.rootNode, cursorOffset, true);
                        if (!currentNode) {
                            return [2, []];
                        }
                        currentNodeRange = {
                            start: doc.positionAt(currentNode.offset),
                            end: doc.positionAt(currentNode.offset + currentNode.length),
                        };
                        overwriteRange = ["string", "number", "boolean", "null"].includes(currentNode === null || currentNode === void 0 ? void 0 : currentNode.type)
                            ? currentNodeRange
                            : args.cursorWordRange;
                        matchedCompletions = Array.from(args.completions.entries()).filter(function (_a) {
                            var _b = __read(_a, 2), path = _b[0], _ = _b[1];
                            return path &&
                                args.codeCompletionStrategy.shouldComplete({
                                    content: args.content,
                                    cursorOffset: cursorOffset,
                                    cursorPosition: args.cursorPosition,
                                    node: currentNode,
                                    path: path,
                                    root: args.rootNode,
                                });
                        });
                        return [4, Promise.all(matchedCompletions.map(function (_a) {
                                var _b = __read(_a, 2), _ = _b[0], completionItemsDelegate = _b[1];
                                return completionItemsDelegate(__assign({ codeCompletionStrategy: args.codeCompletionStrategy, currentNode: currentNode, currentNodeRange: currentNodeRange, cursorOffset: cursorOffset, cursorPosition: args.cursorPosition, document: doc, overwriteRange: overwriteRange, rootNode: args.rootNode }, (args.extraCompletionFunctionsArgs || {})));
                            }))];
                    case 1:
                        result = _a.sent();
                        return [2, Promise.resolve(result.flat())];
                }
            });
        });
    };
    EditorLanguageService.prototype.getDiagnostics = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var docVersion, textDocument, refValidationResults, schemaValidationResults;
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        if (!args.rootNode) {
                            return [2, []];
                        }
                        docVersion = Math.floor(Math.random() * 1000);
                        textDocument = vscode_languageserver_textdocument_1.TextDocument.create(args.uriPath, this.args.lang.fileLanguage, docVersion, args.content);
                        refValidationResults = args.validationMap
                            ? (0, refValidation_1.doRefValidation)({ textDocument: textDocument, rootNode: args.rootNode, validationMap: args.validationMap })
                            : [];
                        return [4, ((_a = args.getSchemaDiagnostics) === null || _a === void 0 ? void 0 : _a.call(args, { textDocument: textDocument, fileMatch: this.args.lang.fileMatch }))];
                    case 1:
                        schemaValidationResults = (_b = (_c.sent())) !== null && _b !== void 0 ? _b : [];
                        return [2, __spreadArray(__spreadArray([], __read(schemaValidationResults), false), __read(refValidationResults), false)];
                }
            });
        });
    };
    EditorLanguageService.prototype.getCodeLenses = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var document, codeLensesFunctionsArgs, result;
            return __generator(this, function (_a) {
                if (!args.content.trim().length) {
                    return [2, args.codeLenses.createNewFile()];
                }
                if (!args.rootNode) {
                    return [2, []];
                }
                document = vscode_languageserver_textdocument_1.TextDocument.create(args.uri, this.args.lang.fileLanguage, 0, args.content);
                codeLensesFunctionsArgs = __assign({ document: document, content: args.content, rootNode: args.rootNode, codeCompletionStrategy: args.codeCompletionStrategy }, args.extraCodeLensesFunctionsArgs);
                result = [];
                Object.keys(args.codeLenses).forEach(function (key) {
                    if (key !== "createNewFile") {
                        result.push.apply(result, __spreadArray([], __read(args.codeLenses[key](codeLensesFunctionsArgs)), false));
                    }
                });
                return [2, result];
            });
        });
    };
    EditorLanguageService.prototype.getSchemaDiagnostics = function (args) {
        return Promise.resolve([]);
    };
    EditorLanguageService.prototype.dispose = function () {
    };
    return EditorLanguageService;
}());
exports.EditorLanguageService = EditorLanguageService;
function findNodeAtLocation(root, path) {
    return (0, findNodesAtLocation_1.findNodesAtLocation)({ root: root, path: path })[0];
}
function findNodeAtOffset(root, offset, includeRightBound) {
    return jsonc.findNodeAtOffset(root, offset, includeRightBound);
}
function getNodePath(node) {
    return jsonc.getNodePath(node);
}
var positions_equals = function (a, b) {
    return (a === null || a === void 0 ? void 0 : a.line) === (b === null || b === void 0 ? void 0 : b.line) && (a === null || a === void 0 ? void 0 : a.character) == (b === null || b === void 0 ? void 0 : b.character);
};
exports.positions_equals = positions_equals;
//# sourceMappingURL=EditorLanguageService.js.map