import { KOGITO_IFRAME_FULLSCREEN_CONTAINER_CLASS, KOGITO_MAIN_CONTAINER_CLASS, KOGITO_MENU_CONTAINER_CLASS, KOGITO_OPEN_REPO_IN_EXTERNAL_EDITOR_CONTAINER_CLASS, } from "./constants";
export function runScriptOnPage(script) {
    const scriptTag = document.createElement("script");
    scriptTag.setAttribute("src", script);
    scriptTag.innerText = script;
    document.body.appendChild(scriptTag);
    scriptTag.remove();
}
let lastUri = window.location.pathname;
export function runAfterUriChange(logger, callback) {
    const checkUriThenCallback = () => {
        const currentUri = window.location.pathname;
        if (lastUri === currentUri) {
            return;
        }
        logger.log(`URI changed from '${lastUri}' to '${currentUri}'. Restarting the extension.`);
        lastUri = currentUri;
        callback();
    };
    runScriptOnPage(chrome.runtime.getURL("scripts/check_url_change.js"));
    window.addEventListener("popstate", () => {
        logger.log("popstate event happened");
        checkUriThenCallback();
    });
    window.addEventListener("pushState", () => {
        logger.log("pushState event happened");
        checkUriThenCallback();
    });
}
export function removeAllChildren(node) {
    while (node.firstChild) {
        node.removeChild(node.firstChild);
    }
}
export function mainContainer(id, container) {
    return container.querySelector(`.${KOGITO_MAIN_CONTAINER_CLASS}.${id}`);
}
export function createAndGetMainContainer(id, container) {
    if (!mainContainer(id, container)) {
        container.insertAdjacentHTML("beforeend", `<div class="${KOGITO_MAIN_CONTAINER_CLASS} ${id}"></div>`);
    }
    return mainContainer(id, container);
}
export function iframeFullscreenContainer(id, container) {
    const element = () => document.querySelector(`.${KOGITO_IFRAME_FULLSCREEN_CONTAINER_CLASS}.${id}`);
    if (!element()) {
        container.insertAdjacentHTML("afterbegin", `<div class="${KOGITO_IFRAME_FULLSCREEN_CONTAINER_CLASS} ${id}" class="hidden"></div>`);
    }
    return element();
}
export function kogitoMenuContainer(id, container) {
    const element = () => document.querySelector(`.${KOGITO_MENU_CONTAINER_CLASS}.${id}`);
    if (!element()) {
        container.insertAdjacentHTML("beforebegin", `<div class="${KOGITO_MENU_CONTAINER_CLASS} ${id} Header-item"></div>`);
    }
    return element();
}
export function openRepoInExternalEditorContainer(id, container) {
    const element = () => document.querySelector(`.${KOGITO_OPEN_REPO_IN_EXTERNAL_EDITOR_CONTAINER_CLASS}.${id}`);
    if (!element()) {
        container.insertAdjacentHTML("beforeend", `<div class="${KOGITO_OPEN_REPO_IN_EXTERNAL_EDITOR_CONTAINER_CLASS} ${id}"></div>`);
    }
    return element();
}
export function openRepoInExternalEditorContainerFromRepositoryHome(id, container) {
    const element = () => document.querySelector(`.${KOGITO_OPEN_REPO_IN_EXTERNAL_EDITOR_CONTAINER_CLASS}.${id}`);
    if (!element()) {
        container.insertAdjacentHTML("beforeend", `<li><div class="${KOGITO_OPEN_REPO_IN_EXTERNAL_EDITOR_CONTAINER_CLASS} ${id}"></div></li>`);
    }
    return element();
}
export function extractOpenFileExtension(url) {
    var _a, _b;
    return (_b = (_a = url
        .split(".")
        .pop()) === null || _a === void 0 ? void 0 : _a.match(/[\w\d]+/)) === null || _b === void 0 ? void 0 : _b.pop();
}
export function extractOpenFilePath(url) {
    var _a, _b;
    const lastDotIndex = url.lastIndexOf(".");
    const splittedUrl = url.split(".");
    const fileExtension = (_b = (_a = splittedUrl
        .pop()) === null || _a === void 0 ? void 0 : _a.match(/[\w\d]+/)) === null || _b === void 0 ? void 0 : _b.pop();
    const filePathWithoutExtension = url.substring(0, lastDotIndex + 1);
    return (filePathWithoutExtension ? filePathWithoutExtension : "") + (fileExtension ? fileExtension : "");
}
export function waitForElementToBeReady(selector) {
    return new Promise((resolve) => {
        if (document.querySelector(selector)) {
            return resolve(document.querySelector(selector));
        }
        const observer = new MutationObserver(() => {
            if (document.querySelector(selector)) {
                resolve(document.querySelector(selector));
                observer.disconnect();
            }
        });
        observer.observe(document.body, {
            childList: true,
            subtree: true,
        });
    });
}
//# sourceMappingURL=utils.js.map