import { jsx as _jsx } from "react/jsx-runtime";
import { Octokit } from "@octokit/rest";
import * as React from "react";
import { useCallback, useContext, useEffect, useLayoutEffect, useState } from "react";
import { useGlobals } from "./GlobalContext";
export const GitHubContext = React.createContext({});
export function useGitHubApi() {
    return useContext(GitHubContext);
}
export function setCookie(name, value) {
    const date = new Date();
    date.setTime(date.getTime() + 10 * 365 * 24 * 60 * 60);
    document.cookie = name + "=" + value + "; expires=" + date.toUTCString() + "; path=/";
}
export function getCookie(name) {
    const value = "; " + document.cookie;
    const parts = value.split("; " + name + "=");
    if (parts.length === 2) {
        return parts.pop().split(";").shift();
    }
}
export function getGitHubApiBaseUrl(baseUrl) {
    if (baseUrl.startsWith("https://")) {
        return "https://api." + baseUrl.slice(8);
    }
    else if (baseUrl.startsWith("http://")) {
        return "http://api." + baseUrl.slice(7);
    }
    else {
        console.error(`Unsupported protocol for GitHub API base URL: ${baseUrl}`);
        return;
    }
}
let octokitInstance;
export const GitHubContextProvider = (props) => {
    const globals = useGlobals();
    const [ready, setReady] = useState(false);
    const [token, setToken] = useState(getCookie(globals.githubAuthTokenCookieName));
    const userIsLoggedIn = useCallback(() => {
        return !!globals.dependencies.all.notificationIndicator();
    }, [globals.dependencies.all]);
    const octokit = useCallback(() => {
        return octokitInstance;
    }, []);
    useEffect(() => {
        if (token) {
            octokitInstance = new Octokit({ auth: token, baseUrl: getGitHubApiBaseUrl(window.location.origin) });
            console.debug("Token found");
        }
        else {
            octokitInstance = new Octokit({ baseUrl: getGitHubApiBaseUrl(window.location.origin) });
            console.debug("Token not found.");
        }
        setReady(true);
    }, [token]);
    useLayoutEffect(() => {
        if (!token) {
            setCookie(globals.githubAuthTokenCookieName, "");
            octokitInstance = new Octokit();
        }
        else {
            setCookie(globals.githubAuthTokenCookieName, token);
            octokitInstance = new Octokit({ auth: token });
        }
    }, [globals.githubAuthTokenCookieName, token]);
    return (_jsx(GitHubContext.Provider, { value: { token, setToken, octokit, userIsLoggedIn }, children: ready && props.children }));
};
//# sourceMappingURL=GitHubContext.js.map