import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { ChannelType, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import * as React from "react";
import { useCallback, useImperativeHandle, useRef, useState } from "react";
import { MonacoEditor } from "./monaco";
import { MonacoEditorOperation } from "./monaco";
const RefForwardingTextEditor = (props, forwardedRef) => {
    const [initialContent, setInitialContent] = useState(undefined);
    const swfTextEditorRef = useRef(null);
    useImperativeHandle(forwardedRef, () => {
        return {
            setContent: (normalizedPosixPathRelativeToTheWorkspaceRoot, newContent) => {
                try {
                    setInitialContent({
                        originalContent: newContent,
                        normalizedPosixPathRelativeToTheWorkspaceRoot,
                    });
                    return Promise.resolve();
                }
                catch (e) {
                    console.error(e);
                    return Promise.reject();
                }
            },
            getContent: () => {
                var _a;
                return Promise.resolve(((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.getContent()) || "");
            },
            getPreview: () => {
                return Promise.resolve("");
            },
            undo: () => {
                var _a;
                return ((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo()) || Promise.resolve();
            },
            redo: () => {
                var _a;
                return ((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.redo()) || Promise.resolve();
            },
            validate: () => {
                return [];
            },
            setTheme: (theme) => {
                var _a;
                return ((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.setTheme(theme)) || Promise.resolve();
            },
        };
    }, []);
    const setValidationErrors = (errors) => {
        if (!initialContent) {
            return;
        }
        const notifications = errors.map((error) => ({
            type: "PROBLEM",
            normalizedPosixPathRelativeToTheWorkspaceRoot: initialContent.normalizedPosixPathRelativeToTheWorkspaceRoot,
            severity: "ERROR",
            message: `${error.message}`,
            position: {
                startLineNumber: error.startLineNumber,
                startColumn: error.startColumn,
                endLineNumber: error.endLineNumber,
                endColumn: error.endColumn,
            },
        }));
        props.setNotifications(initialContent.normalizedPosixPathRelativeToTheWorkspaceRoot, notifications);
    };
    const isVscode = useCallback(() => {
        return props.channelType === ChannelType.VSCODE_DESKTOP || props.channelType === ChannelType.VSCODE_WEB;
    }, [props.channelType]);
    const onContentChanged = useCallback((newContent, operation) => {
        var _a, _b;
        switch (operation) {
            case MonacoEditorOperation.EDIT:
                props.onNewEdit(new WorkspaceEdit(newContent));
                break;
            case MonacoEditorOperation.UNDO:
                if (!isVscode()) {
                    (_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo();
                }
                props.onStateControlCommandUpdate(StateControlCommand.UNDO);
                break;
            case MonacoEditorOperation.REDO:
                if (!isVscode()) {
                    (_b = swfTextEditorRef.current) === null || _b === void 0 ? void 0 : _b.redo();
                }
                props.onStateControlCommandUpdate(StateControlCommand.REDO);
                break;
        }
    }, [props, isVscode]);
    return (_jsx(_Fragment, { children: isVscode() ||
            (initialContent && (_jsx(MonacoEditor, { channelType: props.channelType, content: initialContent.originalContent, fileName: initialContent.normalizedPosixPathRelativeToTheWorkspaceRoot, onContentChange: onContentChanged, setValidationErrors: setValidationErrors, ref: swfTextEditorRef, isReadOnly: props.isReadOnly }))) }));
};
export const TextEditor = React.forwardRef(RefForwardingTextEditor);
//# sourceMappingURL=TextEditor.js.map