"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNsDeclarationPropName = getNsDeclarationPropName;
function getNsDeclarationPropName(_a) {
    var namespace = _a.namespace, atInstanceNs = _a.atInstanceNs, fallingBackToNs = _a.fallingBackToNs;
    var instanceNsKey = atInstanceNs.get(namespace);
    if (instanceNsKey === undefined) {
        instanceNsKey = fallingBackToNs.get(namespace);
        if (instanceNsKey === undefined) {
            throw new Error("DMN MARSHALLER: Can't find namespace declaration for '".concat(namespace, "'"));
        }
    }
    if (instanceNsKey === "") {
        return "@_xmlns";
    }
    else {
        return "@_xmlns:".concat(instanceNsKey.split(":")[0]);
    }
}
//# sourceMappingURL=ns.js.map