import { Actions } from "./Actions";
import { validateDataFields } from "../validation";
import { Builder } from "../paths";
export const DataDictionaryReducer = (historyService, validationRegistry) => {
    return (state, action) => {
        switch (action.type) {
            case Actions.AddDataDictionaryField:
                historyService.batch(state, Builder().forDataDictionary().build(), (draft) => {
                    draft.DataField.push({
                        name: action.payload.name,
                        dataType: action.payload.type,
                        optype: action.payload.optype,
                    });
                });
                break;
            case Actions.DeleteDataDictionaryField:
                historyService.batch(state, Builder().forDataDictionary().build(), (draft) => {
                    const index = action.payload.index;
                    if (index >= 0 && index < draft.DataField.length) {
                        draft.DataField.splice(index, 1);
                    }
                }, (pmml) => {
                    validationRegistry.clear(Builder().forDataDictionary().build());
                    validateDataFields(pmml.DataDictionary.DataField, validationRegistry);
                });
                break;
            case Actions.ReorderDataDictionaryFields:
                historyService.batch(state, Builder().forDataDictionary().build(), (draft) => {
                    const [removed] = draft.DataField.splice(action.payload.oldIndex, 1);
                    draft.DataField.splice(action.payload.newIndex, 0, removed);
                }, (pmml) => {
                    validationRegistry.clear(Builder().forDataDictionary().build());
                    validateDataFields(pmml.DataDictionary.DataField, validationRegistry);
                });
                break;
            case Actions.AddBatchDataDictionaryFields:
                historyService.batch(state, Builder().forDataDictionary().build(), (draft) => {
                    action.payload.dataDictionaryFields.forEach((name) => {
                        draft.DataField.push({
                            name,
                            dataType: "string",
                            optype: "categorical",
                        });
                    });
                });
        }
        return state;
    };
};
//# sourceMappingURL=DataDictionaryReducer.js.map