import { Actions } from "./Actions";
import { hasIntervals, hasValidValues, shouldConstraintsBeCleared, validateDataField, validateDataFields, } from "../validation";
import { Builder } from "../paths";
export const DataDictionaryFieldReducer = (historyService, validationRegistry) => {
    return (state, action) => {
        switch (action.type) {
            case Actions.UpdateDataDictionaryField:
                const dataField = action.payload.dataField;
                const dataDictionaryIndex = action.payload.dataDictionaryIndex;
                historyService.batch(state, Builder().forDataDictionary().forDataField().build(), (draft) => {
                    var _a;
                    if (dataDictionaryIndex >= 0 && dataDictionaryIndex < draft.length) {
                        if (shouldConstraintsBeCleared(dataField, draft[dataDictionaryIndex].isCyclic, draft[dataDictionaryIndex].dataType, draft[dataDictionaryIndex].optype)) {
                            delete dataField.Interval;
                            dataField.Value = (_a = dataField.Value) === null || _a === void 0 ? void 0 : _a.filter((value) => value.property === "invalid" || value.property === "missing");
                        }
                        if (dataField.isCyclic === "1" && dataField.optype === "ordinal" && hasIntervals(dataField)) {
                            delete dataField.Interval;
                        }
                        if (dataField.optype === "categorical" && dataField.isCyclic !== undefined) {
                            delete dataField.isCyclic;
                        }
                        if (((dataField.isCyclic === "1" && dataField.optype === "ordinal") ||
                            (dataField.dataType === "string" && dataField.optype === "ordinal")) &&
                            !hasValidValues(dataField)) {
                            dataField.Value = (dataField.Value || []).concat({ value: "" });
                        }
                        draft[dataDictionaryIndex] = dataField;
                    }
                }, () => {
                    validationRegistry.clear(Builder().forDataDictionary().forDataField(dataDictionaryIndex).build());
                    validateDataField(dataField, dataDictionaryIndex, validationRegistry);
                });
                break;
            case Actions.Validate:
                validationRegistry.clear(Builder().forDataDictionary().forDataField().build());
                validateDataFields(state, validationRegistry);
        }
        return state;
    };
};
//# sourceMappingURL=DataDictionaryFieldReducer.js.map