import { useDispatch } from "react-redux";
import { Actions } from "../reducers";
export const useBatchDispatch = (service, getCurrentState) => {
    const dispatch = useDispatch();
    return (action) => {
        const result = dispatch(action);
        dispatch({
            type: Actions.Refresh,
            payload: {
                pmml: service.commit(getCurrentState()),
            },
        });
        return result;
    };
};
//# sourceMappingURL=BatchDispatchHook.js.map