import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo, useState } from "react";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { CloseIcon } from "@patternfly/react-icons/dist/js/icons/close-icon";
import { WarningTriangleIcon } from "@patternfly/react-icons/dist/js/icons/warning-triangle-icon";
import { OutputsContainer } from "./OutputsContainer";
import { Operation, useOperation } from "../../EditorScorecard";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import { ValidationIndicatorTooltip } from "../../EditorCore/atoms";
export const OutputsHandler = (props) => {
    const { modelIndex, output, miningSchema, validateOutputFieldName, deleteOutputField, commitOutputField } = props;
    const [isModalOpen, setIsModalOpen] = useState(false);
    const { setActiveOperation } = useOperation();
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forOutput().build()), [modelIndex, output, miningSchema]);
    const toggleModal = () => {
        setActiveOperation(Operation.NONE);
        setIsModalOpen(!isModalOpen);
    };
    const header = (_jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { isFilled: true, children: _jsx(Title, { headingLevel: "h1", size: TitleSizes["2xl"], children: "Outputs" }) }), _jsx(SplitItem, { children: _jsx(Button, { type: "button", variant: ButtonVariant.plain, onClick: toggleModal, "data-title": "OutputsModalClose", children: _jsx(CloseIcon, {}) }) })] }));
    return (_jsxs(_Fragment, { children: [validations.length === 0 && (_jsx(Button, { variant: "secondary", onClick: toggleModal, "data-title": "Outputs", children: "Set Outputs" })), validations.length > 0 && (_jsx(ValidationIndicatorTooltip, { validations: validations, children: _jsx(Button, { variant: "secondary", icon: _jsx(WarningTriangleIcon, { size: "sm", color: "orange" }), onClick: toggleModal, "data-title": "Outputs", children: "Set Outputs" }) })), _jsx(Modal, { "aria-label": "outputs", title: "Outputs", header: header, isOpen: isModalOpen, showClose: false, variant: ModalVariant.large, onEscapePress: () => false, "data-title": "OutputsModal", children: _jsx(OutputsContainer, { modelIndex: modelIndex, output: output, miningSchema: miningSchema, validateOutputFieldName: validateOutputFieldName, deleteOutputField: deleteOutputField, commitOutputField: commitOutputField }) })] }));
};
//# sourceMappingURL=OutputsHandler.js.map