import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useRef, useState } from "react";
import { Form } from "@patternfly/react-core/dist/js/components/Form";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Operation, useOperation } from "../../EditorScorecard";
import { EmptyStateNoOutput } from "./EmptyStateNoOutput";
import OutputFieldRow from "../molecules/OutputFieldRow";
import OutputFieldEditRow from "../molecules/OutputFieldEditRow";
import "./OutputFieldsTable.scss";
const OutputFieldsTable = (props) => {
    const { modelIndex, outputs, selectedOutputIndex, setSelectedOutputIndex, validateOutputFieldName, viewExtendedProperties, onAddOutputField, onDeleteOutputField, onCommitAndClose, onCommit, onCancel, } = props;
    const addOutputRowRef = useRef(null);
    const [outputFieldFocusIndex, setOutputFieldFocusIndex] = useState(undefined);
    const { activeOperation, setActiveOperation } = useOperation();
    useEffect(() => {
        if (activeOperation === Operation.UPDATE_OUTPUT && addOutputRowRef.current) {
            addOutputRowRef.current.scrollIntoView({ behavior: "smooth" });
        }
    }, [activeOperation]);
    useEffect(() => {
        if (selectedOutputIndex === outputs.length) {
            setSelectedOutputIndex(undefined);
            setActiveOperation(Operation.NONE);
        }
    }, [outputs, selectedOutputIndex]);
    useEffect(() => {
        var _a;
        if (outputFieldFocusIndex !== undefined) {
            (_a = document.querySelector(`#output-field-n${outputFieldFocusIndex}`)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [outputs, outputFieldFocusIndex]);
    const onEdit = (index) => {
        setSelectedOutputIndex(index);
        setActiveOperation(Operation.UPDATE_OUTPUT);
    };
    const handleDelete = (index, interaction) => {
        var _a;
        onDelete(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setOutputFieldFocusIndex(index);
        }
        setSelectedOutputIndex(undefined);
    };
    const onDelete = (index) => {
        if (index !== undefined) {
            onDeleteOutputField(index);
        }
    };
    const onValidateOutputFieldName = (index, nameToValidate) => {
        return validateOutputFieldName(index, nameToValidate);
    };
    return (_jsxs(Form, { "data-testid": "output-fields-table", onSubmit: (e) => {
            e.stopPropagation();
            e.preventDefault();
        }, children: [_jsx("section", { children: outputs.map((o, index) => {
                    const isRowInEditMode = selectedOutputIndex === index && activeOperation === Operation.UPDATE_OUTPUT;
                    return (_jsxs("article", { className: `editable-item output-item-n${index} ${isRowInEditMode ? "editable-item--editing" : ""}`, children: [isRowInEditMode && (_jsx("div", { ref: addOutputRowRef, children: _jsx(OutputFieldEditRow, { modelIndex: modelIndex, outputField: o, outputFieldIndex: index, validateOutputName: (_name) => onValidateOutputFieldName(index, _name), viewExtendedProperties: viewExtendedProperties, onCommitAndClose: onCommitAndClose, onCommit: onCommit, onCancel: onCancel }) })), !isRowInEditMode && (_jsx(OutputFieldRow, { modelIndex: modelIndex, outputField: o, outputFieldIndex: index, onEditOutputField: () => onEdit(index), onDeleteOutputField: (interaction) => handleDelete(index, interaction) }))] }, index));
                }) }), outputs.length === 0 && (_jsx(Bullseye, { children: _jsx(EmptyStateNoOutput, { onAddOutputField: onAddOutputField }) }))] }));
};
export default OutputFieldsTable;
//# sourceMappingURL=OutputFieldsTable.js.map