import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useMemo, useState } from "react";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { FormSelect, FormSelectOption } from "@patternfly/react-core/dist/js/components/FormSelect";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { GenericSelector } from "../../EditorScorecard/atoms";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
export const OutputFieldExtendedProperties = (props) => {
    const { activeOutputField, activeOutputFieldIndex, modelIndex, targetFields, commit } = props;
    const [optype, setOptype] = useState();
    const [targetField, setTargetField] = useState();
    const [feature, setFeature] = useState();
    const [value, setValue] = useState();
    const [rank, setRank] = useState();
    const [rankOrder, setRankOrder] = useState();
    const [segmentId, setSegmentId] = useState();
    const [isFinalResult, setIsFinalResult] = useState();
    useEffect(() => {
        if (activeOutputField === undefined) {
            return;
        }
        setOptype(activeOutputField.optype);
        setTargetField(activeOutputField.targetField);
        setFeature(activeOutputField.feature);
        setValue(activeOutputField.value);
        setRank(activeOutputField.rank);
        setRankOrder(activeOutputField.rankOrder);
        setSegmentId(activeOutputField.segmentId);
        setIsFinalResult(activeOutputField.isFinalResult);
    }, [props]);
    const targetFieldsOptions = useMemo(() => {
        const options = [...targetFields];
        if (options.length) {
            options.sort().unshift("");
        }
        return options;
    }, [targetFields]);
    const toNumber = (_value) => {
        if (_value === "") {
            return undefined;
        }
        const n = Number(_value);
        if (isNaN(n)) {
            return undefined;
        }
        return n;
    };
    const optypeEditor = GenericSelectorEditor("output-optype", ["", "categorical", "continuous", "ordinal"], (optype !== null && optype !== void 0 ? optype : "").toString(), (_selection) => {
        setOptype(_selection === "" ? undefined : _selection);
        commit({
            optype: _selection === "" ? undefined : _selection,
        });
    });
    const featureEditor = GenericSelectorEditor("output-feature", [
        { value: "" },
        { value: "decision", isDisabled: true },
        { value: "predictedValue" },
        { value: "reasonCode" },
        { value: "transformedValue", isDisabled: true },
        { value: "warning" },
    ], (feature !== null && feature !== void 0 ? feature : "").toString(), (_selection) => {
        setFeature(_selection === "" ? undefined : _selection);
        commit({
            feature: _selection === "" ? undefined : _selection,
        });
    });
    const rankOrderEditor = GenericSelectorEditor("output-rankOrder", ["", "ascending", "descending"], (rankOrder !== null && rankOrder !== void 0 ? rankOrder : "").toString(), (_selection) => {
        setRankOrder(_selection === "" ? undefined : _selection);
        commit({
            rankOrder: _selection === "" ? undefined : _selection,
        });
    }, value !== undefined && value.length > 0);
    const isFinalResultEditor = GenericSelectorEditor("output-isFinalResult", ["", "true", "false"], (isFinalResult !== null && isFinalResult !== void 0 ? isFinalResult : "").toString(), (_selection) => {
        setIsFinalResult(_selection === "" ? undefined : Boolean(_selection));
        commit({
            isFinalResult: _selection === "" ? undefined : Boolean(_selection),
        });
    });
    const { validationRegistry } = useValidationRegistry();
    const validationsTargetField = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forOutput().forOutputField(activeOutputFieldIndex).forTargetField().build()), [modelIndex, activeOutputFieldIndex, activeOutputField]);
    return (_jsxs(Form, { children: [_jsx(FormGroup, { label: "optype", fieldId: "output-optype-helper", helperText: "Indicates the admissible operations on the values.", className: "outputs-container__extended-properties__field", children: optypeEditor }), _jsx(FormGroup, { label: "Target field", fieldId: "output-targetField-helper", helperText: validationsTargetField.length === 0 ? "" : validationsTargetField[0].message, className: "outputs-container__extended-properties__field", validated: validationsTargetField.length === 0 ? "default" : "warning", labelIcon: !targetFieldsOptions.length ? (_jsx(Tooltip, { content: "There are no Mining Schema fields with target usage type.", children: _jsx("button", { "aria-label": "More info for Target Field", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) })) : (_jsx(_Fragment, {})), children: _jsx(FormSelect, { id: "output-targetField", value: (targetField !== null && targetField !== void 0 ? targetField : "").toString(), onChange: (selection) => {
                        if (selection !== targetField) {
                            setTargetField(selection === "" ? undefined : selection);
                            commit({ targetField: selection === "" ? undefined : selection });
                        }
                    }, isDisabled: !targetFieldsOptions.length, validated: validationsTargetField.length === 0 ? "default" : "warning", children: targetFieldsOptions.map((option, index) => (_jsx(FormSelectOption, { value: option, label: option }, index))) }) }), _jsx(FormGroup, { label: "Feature", fieldId: "output-feature-helper", helperText: "Specifies the value the output field takes from the computed mining result.", className: "outputs-container__extended-properties__field", labelIcon: _jsx(Tooltip, { content: "Decision and Transformed value are not supported by scorecards", children: _jsx("button", { "aria-label": "More info about Feature", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: featureEditor }), _jsx(FormGroup, { label: "Value", fieldId: "output-value-helper", helperText: "Used in conjunction with result features referring to specific values.", className: "outputs-container__extended-properties__field", labelIcon: _jsx(Tooltip, { content: "Value property cannot be used together with Rank property", children: _jsx("button", { "aria-label": "More info about Feature", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: _jsx(TextInput, { type: "text", id: "output-value", name: "output-value", "aria-describedby": "output-value-helper", autoComplete: "off", value: (value !== null && value !== void 0 ? value : "").toString(), onChange: (e) => setValue(e), onBlur: () => commit({
                        value: value === "" ? undefined : value,
                    }), isDisabled: rank !== undefined }) }), _jsx(FormGroup, { label: "Rank", fieldId: "output-rank-helper", helperText: "Specifies the rank of the feature value from the mining result that should be selected.", className: "outputs-container__extended-properties__field", labelIcon: _jsx(Tooltip, { content: "Rank property cannot be used together with Value property", children: _jsx("button", { "aria-label": "More info about Feature", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: _jsx(TextInput, { type: "number", id: "output-rank", name: "output-rank", "aria-describedby": "output-rank-helper", autoComplete: "off", value: rank !== null && rank !== void 0 ? rank : "", onChange: (e) => setRank(toNumber(e)), onBlur: () => commit({
                        rank: rank,
                    }), isDisabled: value !== undefined && value.length > 0 }) }), _jsx(FormGroup, { label: "Rank order", fieldId: "output-rankOrder-helper", helperText: "Determines the sorting order when ranking the results.", className: "outputs-container__extended-properties__field", children: rankOrderEditor }), _jsx(FormGroup, { label: "Segment Id", fieldId: "output-segmentId-helper", helperText: "Provides an approach to deliver results from Segments.", className: "outputs-container__extended-properties__field", children: _jsx(TextInput, { type: "text", id: "output-segmentId", name: "output-segmentId", "aria-describedby": "output-segmentId-helper", autoComplete: "off", value: segmentId !== null && segmentId !== void 0 ? segmentId : "", onChange: (e) => setSegmentId(e), onBlur: () => commit({
                        segmentId: segmentId,
                    }) }) }), _jsx(FormGroup, { label: "Final result?", fieldId: "output-isFinalResult-helper", helperText: "Should the field be returned to the user or is only used as input.", className: "outputs-container__extended-properties__field", children: isFinalResultEditor })] }));
};
const GenericSelectorEditor = (id, items, selection, onSelect, isDisabled) => {
    return _jsx(GenericSelector, { id: id, items: items, selection: selection, onSelect: onSelect, isDisabled: isDisabled });
};
//# sourceMappingURL=OutputFieldExtendedProperties.js.map