import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo, useState } from "react";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { CloseIcon } from "@patternfly/react-icons/dist/js/icons/close-icon";
import { WarningTriangleIcon } from "@patternfly/react-icons/dist/js/icons/warning-triangle-icon";
import MiningSchemaContainer from "../MiningSchemaContainer/MiningSchemaContainer";
import { useSelector } from "react-redux";
import { Actions } from "../../../reducers";
import { useBatchDispatch, useHistoryService } from "../../../history";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import { ValidationIndicatorTooltip } from "../../EditorCore/atoms";
const MiningSchemaHandler = (props) => {
    const { miningSchema, modelIndex } = props;
    const [isMiningSchemaOpen, setIsMiningSchemaOpen] = useState(false);
    const dataDictionary = useSelector((state) => state.DataDictionary);
    const { service, getCurrentState } = useHistoryService();
    const dispatch = useBatchDispatch(service, getCurrentState);
    const addMiningField = (names) => {
        dispatch({
            type: Actions.AddMiningSchemaFields,
            payload: {
                modelIndex: modelIndex,
                names: names,
            },
        });
    };
    const deleteMiningField = (index) => {
        dispatch({
            type: Actions.DeleteMiningSchemaField,
            payload: {
                modelIndex: modelIndex,
                miningSchemaIndex: index,
                name: miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField[index].name,
            },
        });
    };
    const updateField = (index, originalName, field) => {
        dispatch({
            type: Actions.UpdateMiningSchemaField,
            payload: {
                modelIndex: modelIndex,
                miningSchemaIndex: index,
                ...field,
                originalName,
            },
        });
    };
    const handleMiningSchemaToggle = () => {
        setIsMiningSchemaOpen(!isMiningSchemaOpen);
    };
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forMiningSchema().build()), [modelIndex, miningSchema, dataDictionary]);
    const header = (_jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { isFilled: true, children: _jsx(Title, { headingLevel: "h1", size: TitleSizes["2xl"], children: "Mining Schema" }) }), _jsx(SplitItem, { children: _jsx(Button, { type: "button", variant: ButtonVariant.plain, onClick: handleMiningSchemaToggle, "data-title": "MiningSchemaModalClose", ouiaId: "editor-close", children: _jsx(CloseIcon, {}) }) })] }));
    return (_jsxs(_Fragment, { children: [validations.length === 0 && (_jsx(Button, { variant: "secondary", onClick: handleMiningSchemaToggle, "data-title": "MiningSchema", ouiaId: "open-mining-schema-editor", children: "Set Mining Schema" })), validations.length > 0 && (_jsx(ValidationIndicatorTooltip, { validations: validations, children: _jsx(Button, { variant: "secondary", icon: _jsx(WarningTriangleIcon, { size: "sm", color: "orange" }), onClick: handleMiningSchemaToggle, "data-title": "MiningSchema", ouiaId: "open-mining-schema-editor", children: "Set Mining Schema" }) })), _jsx(Modal, { "aria-label": "mining-schema", title: "Mining Schema", header: header, isOpen: isMiningSchemaOpen, showClose: false, variant: ModalVariant.large, onEscapePress: () => false, "data-title": "MiningSchemaModal", ouiaId: "mining-schema-editor", children: _jsx(MiningSchemaContainer, { modelIndex: modelIndex, miningSchema: miningSchema, dataDictionary: dataDictionary, onAddField: addMiningField, onDeleteField: deleteMiningField, onUpdateField: updateField }) })] }));
};
export default MiningSchemaHandler;
//# sourceMappingURL=MiningSchemaHandler.js.map