import { ResourceFetch } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { Ingress } from "kubernetes-models/networking.k8s.io/v1";
import { ResourceDataSource, commonLabels, runtimeLabels, } from "../common";
export const INGRESS_TEMPLATE = (args) => {
    return new Ingress({
        metadata: {
            name: args.resourceName,
            namespace: args.namespace,
            labels: {
                ...commonLabels({ ...args }),
                ...runtimeLabels(),
            },
            annotations: {
                "nginx.ingress.kubernetes.io/ssl-redirect": "false",
                "nginx.ingress.kubernetes.io/backend-protocol": "HTTP",
            },
        },
        spec: {
            rules: [
                {
                    http: {
                        paths: [
                            {
                                path: `/${args.resourceName}`,
                                pathType: "Prefix",
                                backend: {
                                    service: {
                                        name: args.resourceName,
                                        port: {
                                            number: 8080,
                                        },
                                    },
                                },
                            },
                        ],
                    },
                },
            ],
        },
    }).toJSON();
};
export class CreateIngress extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : INGRESS_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/apis/${Ingress.apiVersion}/namespaces/${this.args.namespace}/ingresses`;
    }
}
export class ListIngresses extends ResourceFetch {
    method() {
        return HttpMethod.GET;
    }
    endpoint() {
        return `/apis/${Ingress.apiVersion}/namespaces/${this.args.namespace}/ingresses`;
    }
}
export class DeleteIngress extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    body() {
        return JSON.stringify({
            propagationPolicy: "Background",
        });
    }
    method() {
        return HttpMethod.DELETE;
    }
    endpoint() {
        return `/apis/${Ingress.apiVersion}/namespaces/${this.args.namespace}/ingresses/${this.args.resourceName}`;
    }
}
//# sourceMappingURL=Ingress.js.map