export const root = {
    element: "definitions",
    type: "DMN12__tDefinitions"
};
export const ns = new Map([
    ["http://www.omg.org/spec/DMN/20180521/MODEL/", ""],
    ["", "http://www.omg.org/spec/DMN/20180521/MODEL/"],
    ["http://www.omg.org/spec/DMN/20180521/DMNDI/", "dmndi:"],
    ["dmndi:", "http://www.omg.org/spec/DMN/20180521/DMNDI/"],
    ["http://www.omg.org/spec/DMN/20180521/DC/", "dc:"],
    ["dc:", "http://www.omg.org/spec/DMN/20180521/DC/"],
    ["http://www.omg.org/spec/DMN/20180521/DI/", "di:"],
    ["di:", "http://www.omg.org/spec/DMN/20180521/DI/"],
]);
export const subs = {
    "": {
        "namedElement": "DMNElement",
        "informationRequirement": "DMNElement",
        "knowledgeRequirement": "DMNElement",
        "authorityRequirement": "DMNElement",
        "artifact": "DMNElement",
        "contextEntry": "DMNElement",
        "definitions": "namedElement",
        "import": "namedElement",
        "elementCollection": "namedElement",
        "drgElement": "namedElement",
        "itemDefinition": "namedElement",
        "informationItem": "namedElement",
        "decision": "drgElement",
        "invocable": "drgElement",
        "inputData": "drgElement",
        "knowledgeSource": "drgElement",
        "performanceIndicator": "businessContextElement",
        "organizationUnit": "businessContextElement",
        "businessKnowledgeModel": "invocable",
        "decisionService": "invocable",
        "literalExpression": "expression",
        "invocation": "expression",
        "decisionTable": "expression",
        "context": "expression",
        "functionDefinition": "expression",
        "relation": "expression",
        "list": "expression",
        "textAnnotation": "artifact",
        "association": "artifact",
    },
    "dmndi:": {
        "dmndi:DMNShape": "dmndi:DMNDiagramElement",
        "dmndi:DMNEdge": "dmndi:DMNDiagramElement",
        "dmndi:DMNStyle": "di:Style",
    },
    "dc:": {},
    "di:": {},
};
export const elements = {
    "DMNElement": "DMN12__tDMNElement",
    "namedElement": "DMN12__tNamedElement",
    "definitions": "DMN12__tDefinitions",
    "import": "DMN12__tImport",
    "elementCollection": "DMN12__tElementCollection",
    "drgElement": "DMN12__tDRGElement",
    "decision": "DMN12__tDecision",
    "businessContextElement": "DMN12__tBusinessContextElement",
    "performanceIndicator": "DMN12__tPerformanceIndicator",
    "organizationUnit": "DMN12__tOrganizationUnit",
    "invocable": "DMN12__tInvocable",
    "businessKnowledgeModel": "DMN12__tBusinessKnowledgeModel",
    "inputData": "DMN12__tInputData",
    "knowledgeSource": "DMN12__tKnowledgeSource",
    "informationRequirement": "DMN12__tInformationRequirement",
    "knowledgeRequirement": "DMN12__tKnowledgeRequirement",
    "authorityRequirement": "DMN12__tAuthorityRequirement",
    "expression": "DMN12__tExpression",
    "itemDefinition": "DMN12__tItemDefinition",
    "literalExpression": "DMN12__tLiteralExpression",
    "invocation": "DMN12__tInvocation",
    "informationItem": "DMN12__tInformationItem",
    "decisionTable": "DMN12__tDecisionTable",
    "artifact": "DMN12__tArtifact",
    "textAnnotation": "DMN12__tTextAnnotation",
    "association": "DMN12__tAssociation",
    "context": "DMN12__tContext",
    "contextEntry": "DMN12__tContextEntry",
    "functionDefinition": "DMN12__tFunctionDefinition",
    "relation": "DMN12__tRelation",
    "list": "DMN12__tList",
    "decisionService": "DMN12__tDecisionService",
    "dmndi:DMNDI": "DMNDI12__DMNDI",
    "dmndi:DMNDiagram": "DMNDI12__DMNDiagram",
    "dmndi:DMNDiagramElement": "DMNDI12__DiagramElement",
    "dmndi:DMNShape": "DMNDI12__DMNShape",
    "dmndi:DMNEdge": "DMNDI12__DMNEdge",
    "dmndi:DMNStyle": "DMNDI12__DMNStyle",
    "dmndi:DMNLabel": "DMNDI12__DMNLabel",
    "dmndi:DMNDecisionServiceDividerLine": "DMNDI12__DMNDecisionServiceDividerLine",
    "dc:Color": "DC__Color",
    "dc:Point": "DC__Point",
    "dc:Bounds": "DC__Bounds",
    "dc:Dimension": "DC__Dimension",
    "di:Style": "DI__Style",
};
export const meta = {
    "DMN12__tDMNElement__extensionElements": {},
    "DMN12__tDMNElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tDMNElement__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonymous type..." },
    },
    "DMN12__tNamedElement__extensionElements": {},
    "DMN12__tNamedElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tNamedElement__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
    },
    "DMN12__tDMNElementReference": {
        "@_href": { type: "string", isArray: false, fromType: "DMN12__tDMNElementReference", xsdType: "xsd:anyURI" },
    },
    "DMN12__tDefinitions__extensionElements": {},
    "DMN12__tDefinitions": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tDefinitions__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN12__tDefinitions", xsdType: "xsd:anyURI" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "DMN12__tDefinitions", xsdType: "xsd:anyURI" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN12__tDefinitions", xsdType: "xsd:anyURI" },
        "@_exporter": { type: "string", isArray: false, fromType: "DMN12__tDefinitions", xsdType: "xsd:string" },
        "@_exporterVersion": { type: "string", isArray: false, fromType: "DMN12__tDefinitions", xsdType: "xsd:string" },
        "import": { type: "DMN12__tImport", isArray: true, fromType: "DMN12__tDefinitions", xsdType: "// local type" },
        "itemDefinition": { type: "DMN12__tItemDefinition", isArray: true, fromType: "DMN12__tDefinitions", xsdType: "// local type" },
        "drgElement": { type: "DMN12__tDRGElement", isArray: true, fromType: "DMN12__tDefinitions", xsdType: "// local type" },
        "artifact": { type: "DMN12__tArtifact", isArray: true, fromType: "DMN12__tDefinitions", xsdType: "// local type" },
        "elementCollection": { type: "DMN12__tElementCollection", isArray: true, fromType: "DMN12__tDefinitions", xsdType: "// local type" },
        "businessContextElement": { type: "DMN12__tBusinessContextElement", isArray: true, fromType: "DMN12__tDefinitions", xsdType: "// local type" },
        "dmndi:DMNDI": { type: "DMNDI12__DMNDI", isArray: false, fromType: "DMN12__tDefinitions", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMN12__tImport__extensionElements": {},
    "DMN12__tImport": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tImport__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN12__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN12__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "DMN12__tImport", xsdType: "xsd:anyURI" },
    },
    "DMN12__tElementCollection__extensionElements": {},
    "DMN12__tElementCollection": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tElementCollection__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "drgElement": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tElementCollection", xsdType: "// local type" },
    },
    "DMN12__tDRGElement__extensionElements": {},
    "DMN12__tDRGElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tDRGElement__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
    },
    "DMN12__tDecision__extensionElements": {},
    "DMN12__tDecision": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tDecision__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "question": { type: "string", isArray: false, fromType: "DMN12__tDecision", xsdType: "xsd:string" },
        "allowedAnswers": { type: "string", isArray: false, fromType: "DMN12__tDecision", xsdType: "xsd:string" },
        "variable": { type: "DMN12__tInformationItem", isArray: false, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "informationRequirement": { type: "DMN12__tInformationRequirement", isArray: true, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "knowledgeRequirement": { type: "DMN12__tKnowledgeRequirement", isArray: true, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "authorityRequirement": { type: "DMN12__tAuthorityRequirement", isArray: true, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "supportedObjective": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "impactedPerformanceIndicator": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "decisionMaker": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "decisionOwner": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "usingProcess": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "usingTask": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecision", xsdType: "// local type" },
        "expression": { type: "DMN12__tExpression", isArray: false, fromType: "DMN12__tDecision", xsdType: "// local type" },
    },
    "DMN12__tBusinessContextElement__extensionElements": {},
    "DMN12__tBusinessContextElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tBusinessContextElement__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN12__tBusinessContextElement", xsdType: "xsd:anyURI" },
    },
    "DMN12__tPerformanceIndicator__extensionElements": {},
    "DMN12__tPerformanceIndicator": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tPerformanceIndicator__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN12__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "impactingDecision": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tPerformanceIndicator", xsdType: "// local type" },
    },
    "DMN12__tOrganizationUnit__extensionElements": {},
    "DMN12__tOrganizationUnit": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tOrganizationUnit__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN12__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "decisionMade": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tOrganizationUnit", xsdType: "// local type" },
        "decisionOwned": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tOrganizationUnit", xsdType: "// local type" },
    },
    "DMN12__tInvocable__extensionElements": {},
    "DMN12__tInvocable": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tInvocable__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN12__tInformationItem", isArray: false, fromType: "DMN12__tInvocable", xsdType: "// local type" },
    },
    "DMN12__tBusinessKnowledgeModel__extensionElements": {},
    "DMN12__tBusinessKnowledgeModel": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tBusinessKnowledgeModel__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN12__tInformationItem", isArray: false, fromType: "DMN12__tInvocable", xsdType: "// local type" },
        "encapsulatedLogic": { type: "DMN12__tFunctionDefinition", isArray: false, fromType: "DMN12__tBusinessKnowledgeModel", xsdType: "// local type" },
        "knowledgeRequirement": { type: "DMN12__tKnowledgeRequirement", isArray: true, fromType: "DMN12__tBusinessKnowledgeModel", xsdType: "// local type" },
        "authorityRequirement": { type: "DMN12__tAuthorityRequirement", isArray: true, fromType: "DMN12__tBusinessKnowledgeModel", xsdType: "// local type" },
    },
    "DMN12__tInputData__extensionElements": {},
    "DMN12__tInputData": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tInputData__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN12__tInformationItem", isArray: false, fromType: "DMN12__tInputData", xsdType: "// local type" },
    },
    "DMN12__tKnowledgeSource__extensionElements": {},
    "DMN12__tKnowledgeSource": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tKnowledgeSource__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN12__tKnowledgeSource", xsdType: "xsd:anyURI" },
        "authorityRequirement": { type: "DMN12__tAuthorityRequirement", isArray: true, fromType: "DMN12__tKnowledgeSource", xsdType: "// local type" },
        "type": { type: "string", isArray: false, fromType: "DMN12__tKnowledgeSource", xsdType: "xsd:string" },
        "owner": { type: "DMN12__tDMNElementReference", isArray: false, fromType: "DMN12__tKnowledgeSource", xsdType: "// local type" },
    },
    "DMN12__tInformationRequirement__extensionElements": {},
    "DMN12__tInformationRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tInformationRequirement__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "requiredDecision": { type: "DMN12__tDMNElementReference", isArray: false, fromType: "DMN12__tInformationRequirement", xsdType: "// local type" },
        "requiredInput": { type: "DMN12__tDMNElementReference", isArray: false, fromType: "DMN12__tInformationRequirement", xsdType: "// local type" },
    },
    "DMN12__tKnowledgeRequirement__extensionElements": {},
    "DMN12__tKnowledgeRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tKnowledgeRequirement__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "requiredKnowledge": { type: "DMN12__tDMNElementReference", isArray: false, fromType: "DMN12__tKnowledgeRequirement", xsdType: "// local type" },
    },
    "DMN12__tAuthorityRequirement__extensionElements": {},
    "DMN12__tAuthorityRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tAuthorityRequirement__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "requiredDecision": { type: "DMN12__tDMNElementReference", isArray: false, fromType: "DMN12__tAuthorityRequirement", xsdType: "// local type" },
        "requiredInput": { type: "DMN12__tDMNElementReference", isArray: false, fromType: "DMN12__tAuthorityRequirement", xsdType: "// local type" },
        "requiredAuthority": { type: "DMN12__tDMNElementReference", isArray: false, fromType: "DMN12__tAuthorityRequirement", xsdType: "// local type" },
    },
    "DMN12__tExpression__extensionElements": {},
    "DMN12__tExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tExpression__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tExpression", xsdType: "xsd:string" },
    },
    "DMN12__tItemDefinition__extensionElements": {},
    "DMN12__tItemDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tItemDefinition__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "DMN12__tItemDefinition", xsdType: "xsd:anyURI" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "DMN12__tItemDefinition", xsdType: "xsd:boolean" },
        "itemComponent": { type: "DMN12__tItemDefinition", isArray: true, fromType: "DMN12__tItemDefinition", xsdType: "// local type" },
        "typeRef": { type: "string", isArray: false, fromType: "DMN12__tItemDefinition", xsdType: "xsd:string" },
        "allowedValues": { type: "DMN12__tUnaryTests", isArray: false, fromType: "DMN12__tItemDefinition", xsdType: "// local type" },
    },
    "DMN12__tLiteralExpression__extensionElements": {},
    "DMN12__tLiteralExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tLiteralExpression__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tExpression", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN12__tLiteralExpression", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "DMN12__tLiteralExpression", xsdType: "xsd:string" },
        "importedValues": { type: "DMN12__tImportedValues", isArray: false, fromType: "DMN12__tLiteralExpression", xsdType: "// local type" },
    },
    "DMN12__tInvocation__extensionElements": {},
    "DMN12__tInvocation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tInvocation__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tExpression", xsdType: "xsd:string" },
        "expression": { type: "DMN12__tExpression", isArray: false, fromType: "DMN12__tInvocation", xsdType: "// local type" },
        "binding": { type: "DMN12__tBinding", isArray: true, fromType: "DMN12__tInvocation", xsdType: "// local type" },
    },
    "DMN12__tBinding": {
        "parameter": { type: "DMN12__tInformationItem", isArray: false, fromType: "DMN12__tBinding", xsdType: "// local type" },
        "expression": { type: "DMN12__tExpression", isArray: false, fromType: "DMN12__tBinding", xsdType: "// local type" },
    },
    "DMN12__tInformationItem__extensionElements": {},
    "DMN12__tInformationItem": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tInformationItem__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tInformationItem", xsdType: "xsd:string" },
    },
    "DMN12__tDecisionTable__extensionElements": {},
    "DMN12__tDecisionTable": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tDecisionTable__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tExpression", xsdType: "xsd:string" },
        "@_hitPolicy": { type: "DMN12__tHitPolicy", isArray: false, fromType: "DMN12__tDecisionTable", xsdType: "// local type" },
        "@_aggregation": { type: "DMN12__tBuiltinAggregator", isArray: false, fromType: "DMN12__tDecisionTable", xsdType: "// local type" },
        "@_preferredOrientation": { type: "DMN12__tDecisionTableOrientation", isArray: false, fromType: "DMN12__tDecisionTable", xsdType: "// local type" },
        "@_outputLabel": { type: "string", isArray: false, fromType: "DMN12__tDecisionTable", xsdType: "xsd:string" },
        "input": { type: "DMN12__tInputClause", isArray: true, fromType: "DMN12__tDecisionTable", xsdType: "// local type" },
        "output": { type: "DMN12__tOutputClause", isArray: true, fromType: "DMN12__tDecisionTable", xsdType: "// local type" },
        "annotation": { type: "DMN12__tRuleAnnotationClause", isArray: true, fromType: "DMN12__tDecisionTable", xsdType: "// local type" },
        "rule": { type: "DMN12__tDecisionRule", isArray: true, fromType: "DMN12__tDecisionTable", xsdType: "// local type" },
    },
    "DMN12__tInputClause__extensionElements": {},
    "DMN12__tInputClause": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tInputClause__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "inputExpression": { type: "DMN12__tLiteralExpression", isArray: false, fromType: "DMN12__tInputClause", xsdType: "// local type" },
        "inputValues": { type: "DMN12__tUnaryTests", isArray: false, fromType: "DMN12__tInputClause", xsdType: "// local type" },
    },
    "DMN12__tOutputClause__extensionElements": {},
    "DMN12__tOutputClause": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tOutputClause__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tOutputClause", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tOutputClause", xsdType: "xsd:string" },
        "outputValues": { type: "DMN12__tUnaryTests", isArray: false, fromType: "DMN12__tOutputClause", xsdType: "// local type" },
        "defaultOutputEntry": { type: "DMN12__tLiteralExpression", isArray: false, fromType: "DMN12__tOutputClause", xsdType: "// local type" },
    },
    "DMN12__tRuleAnnotationClause": {
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tRuleAnnotationClause", xsdType: "xsd:string" },
    },
    "DMN12__tDecisionRule__extensionElements": {},
    "DMN12__tDecisionRule": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tDecisionRule__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "inputEntry": { type: "DMN12__tUnaryTests", isArray: true, fromType: "DMN12__tDecisionRule", xsdType: "// local type" },
        "outputEntry": { type: "DMN12__tLiteralExpression", isArray: true, fromType: "DMN12__tDecisionRule", xsdType: "// local type" },
        "annotationEntry": { type: "DMN12__tRuleAnnotation", isArray: true, fromType: "DMN12__tDecisionRule", xsdType: "// local type" },
    },
    "DMN12__tRuleAnnotation": {
        "text": { type: "string", isArray: false, fromType: "DMN12__tRuleAnnotation", xsdType: "xsd:string" },
    },
    "DMN12__tImportedValues__extensionElements": {},
    "DMN12__tImportedValues": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tImportedValues__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN12__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN12__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "DMN12__tImport", xsdType: "xsd:anyURI" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN12__tImportedValues", xsdType: "xsd:anyURI" },
        "importedElement": { type: "string", isArray: false, fromType: "DMN12__tImportedValues", xsdType: "xsd:string" },
    },
    "DMN12__tArtifact__extensionElements": {},
    "DMN12__tArtifact": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tArtifact__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
    },
    "DMN12__tTextAnnotation__extensionElements": {},
    "DMN12__tTextAnnotation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tTextAnnotation__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_textFormat": { type: "string", isArray: false, fromType: "DMN12__tTextAnnotation", xsdType: "xsd:string" },
        "text": { type: "string", isArray: false, fromType: "DMN12__tTextAnnotation", xsdType: "xsd:string" },
    },
    "DMN12__tAssociation__extensionElements": {},
    "DMN12__tAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tAssociation__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_associationDirection": { type: "DMN12__tAssociationDirection", isArray: false, fromType: "DMN12__tAssociation", xsdType: "// local type" },
        "sourceRef": { type: "DMN12__tDMNElementReference", isArray: false, fromType: "DMN12__tAssociation", xsdType: "// local type" },
        "targetRef": { type: "DMN12__tDMNElementReference", isArray: false, fromType: "DMN12__tAssociation", xsdType: "// local type" },
    },
    "DMN12__tContext__extensionElements": {},
    "DMN12__tContext": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tContext__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tExpression", xsdType: "xsd:string" },
        "contextEntry": { type: "DMN12__tContextEntry", isArray: true, fromType: "DMN12__tContext", xsdType: "// local type" },
    },
    "DMN12__tContextEntry__extensionElements": {},
    "DMN12__tContextEntry": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tContextEntry__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "variable": { type: "DMN12__tInformationItem", isArray: false, fromType: "DMN12__tContextEntry", xsdType: "// local type" },
        "expression": { type: "DMN12__tExpression", isArray: false, fromType: "DMN12__tContextEntry", xsdType: "// local type" },
    },
    "DMN12__tFunctionDefinition__extensionElements": {},
    "DMN12__tFunctionDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tFunctionDefinition__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tExpression", xsdType: "xsd:string" },
        "@_kind": { type: "DMN12__tFunctionKind", isArray: false, fromType: "DMN12__tFunctionDefinition", xsdType: "// local type" },
        "formalParameter": { type: "DMN12__tInformationItem", isArray: true, fromType: "DMN12__tFunctionDefinition", xsdType: "// local type" },
        "expression": { type: "DMN12__tExpression", isArray: false, fromType: "DMN12__tFunctionDefinition", xsdType: "// local type" },
    },
    "DMN12__tRelation__extensionElements": {},
    "DMN12__tRelation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tRelation__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tExpression", xsdType: "xsd:string" },
        "column": { type: "DMN12__tInformationItem", isArray: true, fromType: "DMN12__tRelation", xsdType: "// local type" },
        "row": { type: "DMN12__tList", isArray: true, fromType: "DMN12__tRelation", xsdType: "// local type" },
    },
    "DMN12__tList__extensionElements": {},
    "DMN12__tList": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tList__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN12__tExpression", xsdType: "xsd:string" },
        "expression": { type: "DMN12__tExpression", isArray: true, fromType: "DMN12__tList", xsdType: "// local type" },
    },
    "DMN12__tUnaryTests__extensionElements": {},
    "DMN12__tUnaryTests": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tUnaryTests__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN12__tUnaryTests", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "DMN12__tUnaryTests", xsdType: "xsd:string" },
    },
    "DMN12__tDecisionService__extensionElements": {},
    "DMN12__tDecisionService": {
        "@_id": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN12__tDecisionService__extensionElements", isArray: false, fromType: "DMN12__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN12__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN12__tInformationItem", isArray: false, fromType: "DMN12__tInvocable", xsdType: "// local type" },
        "outputDecision": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecisionService", xsdType: "// local type" },
        "encapsulatedDecision": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecisionService", xsdType: "// local type" },
        "inputDecision": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecisionService", xsdType: "// local type" },
        "inputData": { type: "DMN12__tDMNElementReference", isArray: true, fromType: "DMN12__tDecisionService", xsdType: "// local type" },
    },
    "DMNDI12__DMNDI": {
        "dmndi:DMNDiagram": { type: "DMNDI12__DMNDiagram", isArray: true, fromType: "DMNDI12__DMNDI", xsdType: "type found from namespace with declaration name 'dmndi'." },
        "dmndi:DMNStyle": { type: "DMNDI12__DMNStyle", isArray: true, fromType: "DMNDI12__DMNDI", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI12__DMNDiagram__extension": {},
    "DMNDI12__DMNDiagram": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI12__DMNDiagram__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "@_name": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_documentation": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_resolution": { type: "float", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:double" },
        "dmndi:Size": { type: "DC__Dimension", isArray: false, fromType: "DMNDI12__DMNDiagram", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:DMNDiagramElement": { type: "DI__DiagramElement", isArray: true, fromType: "DMNDI12__DMNDiagram", xsdType: "type found from namespace with declaration name 'di'." },
    },
    "DMNDI12__DMNShape__extension": {},
    "DMNDI12__DMNShape": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI12__DMNShape__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Shape", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_dmnElementRef": { type: "string", isArray: false, fromType: "DMNDI12__DMNShape", xsdType: "xsd:QName" },
        "@_isListedInputData": { type: "boolean", isArray: false, fromType: "DMNDI12__DMNShape", xsdType: "xsd:boolean" },
        "@_isCollapsed": { type: "boolean", isArray: false, fromType: "DMNDI12__DMNShape", xsdType: "xsd:boolean" },
        "dmndi:DMNLabel": { type: "DMNDI12__DMNLabel", isArray: false, fromType: "DMNDI12__DMNShape", xsdType: "type found from namespace with declaration name 'dmndi'." },
        "dmndi:DMNDecisionServiceDividerLine": { type: "DMNDI12__DMNDecisionServiceDividerLine", isArray: false, fromType: "DMNDI12__DMNShape", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI12__DMNDecisionServiceDividerLine__extension": {},
    "DMNDI12__DMNDecisionServiceDividerLine": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI12__DMNDecisionServiceDividerLine__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "di:waypoint": { type: "DC__Point", isArray: true, fromType: "DI__Edge", xsdType: "type found from namespace with declaration name 'dc'." },
    },
    "DMNDI12__DMNEdge__extension": {},
    "DMNDI12__DMNEdge": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI12__DMNEdge__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "di:waypoint": { type: "DC__Point", isArray: true, fromType: "DI__Edge", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_dmnElementRef": { type: "string", isArray: false, fromType: "DMNDI12__DMNEdge", xsdType: "xsd:QName" },
        "dmndi:DMNLabel": { type: "DMNDI12__DMNLabel", isArray: false, fromType: "DMNDI12__DMNEdge", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI12__DMNLabel__extension": {},
    "DMNDI12__DMNLabel": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI12__DMNLabel__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Shape", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:Text": { type: "string", isArray: false, fromType: "DMNDI12__DMNLabel", xsdType: "xsd:string" },
    },
    "DMNDI12__DMNStyle__extension": {},
    "DMNDI12__DMNStyle": {
        "@_id": { type: "string", isArray: false, fromType: "DI__Style", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI12__DMNStyle__extension", isArray: false, fromType: "DI__Style", xsdType: "Anonumous type..." },
        "@_fontFamily": { type: "string", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "xsd:string" },
        "@_fontSize": { type: "float", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "xsd:double" },
        "@_fontItalic": { type: "boolean", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontBold": { type: "boolean", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontUnderline": { type: "boolean", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontStrikeThrough": { type: "boolean", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "xsd:boolean" },
        "@_labelHorizontalAlignement": { type: "DC__AlignmentKind", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_labelVerticalAlignment": { type: "DC__AlignmentKind", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:FillColor": { type: "DC__Color", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:StrokeColor": { type: "DC__Color", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:FontColor": { type: "DC__Color", isArray: false, fromType: "DMNDI12__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
    },
    "DC__Color": {
        "@_red": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
        "@_green": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
        "@_blue": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
    },
    "DC__Point": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
    },
    "DC__Dimension": {
        "@_width": { type: "float", isArray: false, fromType: "DC__Dimension", xsdType: "xsd:double" },
        "@_height": { type: "float", isArray: false, fromType: "DC__Dimension", xsdType: "xsd:double" },
    },
    "DC__Bounds": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_width": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_height": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
    },
    "DI__DiagramElement__extension": {},
    "DI__Diagram__extension": {},
    "DI__Shape__extension": {},
    "DI__Edge__extension": {},
    "DI__Style__extension": {},
};
//# sourceMappingURL=meta.js.map