export const root = {
    element: "definitions",
    type: "dmn__tDefinitions"
};
export const ns = new Map([
    ["http://www.omg.org/spec/DMN/20151101/dmn.xsd", ""],
    ["", "http://www.omg.org/spec/DMN/20151101/dmn.xsd"],
]);
export const subs = {
    "": {
        "namedElement": "DMNElement",
        "artifact": "DMNElement",
        "definitions": "namedElement",
        "elementCollection": "namedElement",
        "drgElement": "namedElement",
        "itemDefinition": "namedElement",
        "informationItem": "namedElement",
        "decisionService": "namedElement",
        "decision": "drgElement",
        "businessKnowledgeModel": "drgElement",
        "inputData": "drgElement",
        "knowledgeSource": "drgElement",
        "performanceIndicator": "businessContextElement",
        "organizationUnit": "businessContextElement",
        "literalExpression": "expression",
        "invocation": "expression",
        "decisionTable": "expression",
        "context": "expression",
        "functionDefinition": "expression",
        "relation": "expression",
        "list": "expression",
        "textAnnotation": "artifact",
        "association": "artifact",
    },
};
export const elements = {
    "DMNElement": "dmn__tDMNElement",
    "namedElement": "dmn__tNamedElement",
    "definitions": "dmn__tDefinitions",
    "import": "dmn__tImport",
    "elementCollection": "dmn__tElementCollection",
    "drgElement": "dmn__tDRGElement",
    "decision": "dmn__tDecision",
    "businessContextElement": "dmn__tBusinessContextElement",
    "performanceIndicator": "dmn__tPerformanceIndicator",
    "organizationUnit": "dmn__tOrganizationUnit",
    "businessKnowledgeModel": "dmn__tBusinessKnowledgeModel",
    "inputData": "dmn__tInputData",
    "knowledgeSource": "dmn__tKnowledgeSource",
    "expression": "dmn__tExpression",
    "itemDefinition": "dmn__tItemDefinition",
    "literalExpression": "dmn__tLiteralExpression",
    "invocation": "dmn__tInvocation",
    "informationItem": "dmn__tInformationItem",
    "decisionTable": "dmn__tDecisionTable",
    "artifact": "dmn__tArtifact",
    "textAnnotation": "dmn__tTextAnnotation",
    "association": "dmn__tAssociation",
    "context": "dmn__tContext",
    "functionDefinition": "dmn__tFunctionDefinition",
    "relation": "dmn__tRelation",
    "list": "dmn__tList",
    "decisionService": "dmn__tDecisionService",
};
export const meta = {
    "dmn__tDMNElement__extensionElements": {},
    "dmn__tDMNElement": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tDMNElement__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonymous type..." },
    },
    "dmn__tDMNElementReference": {
        "@_href": { type: "string", isArray: false, fromType: "dmn__tDMNElementReference", xsdType: "xsd:anyURI" },
    },
    "dmn__tDefinitions__extensionElements": {},
    "dmn__tDefinitions": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tDefinitions__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "dmn__tDefinitions", xsdType: "xsd:anyURI" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "dmn__tDefinitions", xsdType: "xsd:anyURI" },
        "@_namespace": { type: "string", isArray: false, fromType: "dmn__tDefinitions", xsdType: "xsd:anyURI" },
        "@_exporter": { type: "string", isArray: false, fromType: "dmn__tDefinitions", xsdType: "xsd:string" },
        "@_exporterVersion": { type: "string", isArray: false, fromType: "dmn__tDefinitions", xsdType: "xsd:string" },
        "import": { type: "dmn__tImport", isArray: true, fromType: "dmn__tDefinitions", xsdType: "// local type" },
        "itemDefinition": { type: "dmn__tItemDefinition", isArray: true, fromType: "dmn__tDefinitions", xsdType: "// local type" },
        "drgElement": { type: "dmn__tDRGElement", isArray: true, fromType: "dmn__tDefinitions", xsdType: "// local type" },
        "artifact": { type: "dmn__tArtifact", isArray: true, fromType: "dmn__tDefinitions", xsdType: "// local type" },
        "elementCollection": { type: "dmn__tElementCollection", isArray: true, fromType: "dmn__tDefinitions", xsdType: "// local type" },
        "businessContextElement": { type: "dmn__tBusinessContextElement", isArray: true, fromType: "dmn__tDefinitions", xsdType: "// local type" },
    },
    "dmn__tImport": {
        "@_namespace": { type: "string", isArray: false, fromType: "dmn__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "dmn__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "dmn__tImport", xsdType: "xsd:anyURI" },
    },
    "dmn__tElementCollection__extensionElements": {},
    "dmn__tElementCollection": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tElementCollection__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "drgElement": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tElementCollection", xsdType: "// local type" },
    },
    "dmn__tDRGElement__extensionElements": {},
    "dmn__tDRGElement": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tDRGElement__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
    },
    "dmn__tDecision__extensionElements": {},
    "dmn__tDecision": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tDecision__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "question": { type: "string", isArray: false, fromType: "dmn__tDecision", xsdType: "xsd:string" },
        "allowedAnswers": { type: "string", isArray: false, fromType: "dmn__tDecision", xsdType: "xsd:string" },
        "variable": { type: "dmn__tInformationItem", isArray: false, fromType: "dmn__tDecision", xsdType: "// local type" },
        "informationRequirement": { type: "dmn__tInformationRequirement", isArray: true, fromType: "dmn__tDecision", xsdType: "// local type" },
        "knowledgeRequirement": { type: "dmn__tKnowledgeRequirement", isArray: true, fromType: "dmn__tDecision", xsdType: "// local type" },
        "authorityRequirement": { type: "dmn__tAuthorityRequirement", isArray: true, fromType: "dmn__tDecision", xsdType: "// local type" },
        "supportedObjective": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecision", xsdType: "// local type" },
        "impactedPerformanceIndicator": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecision", xsdType: "// local type" },
        "decisionMaker": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecision", xsdType: "// local type" },
        "decisionOwner": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecision", xsdType: "// local type" },
        "usingProcess": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecision", xsdType: "// local type" },
        "usingTask": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecision", xsdType: "// local type" },
        "expression": { type: "dmn__tExpression", isArray: false, fromType: "dmn__tDecision", xsdType: "// local type" },
    },
    "dmn__tBusinessContextElement__extensionElements": {},
    "dmn__tBusinessContextElement": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tBusinessContextElement__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "dmn__tBusinessContextElement", xsdType: "xsd:anyURI" },
    },
    "dmn__tPerformanceIndicator__extensionElements": {},
    "dmn__tPerformanceIndicator": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tPerformanceIndicator__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "dmn__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "impactingDecision": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tPerformanceIndicator", xsdType: "// local type" },
    },
    "dmn__tOrganizationUnit__extensionElements": {},
    "dmn__tOrganizationUnit": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tOrganizationUnit__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "dmn__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "decisionMade": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tOrganizationUnit", xsdType: "// local type" },
        "decisionOwned": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tOrganizationUnit", xsdType: "// local type" },
    },
    "dmn__tBusinessKnowledgeModel__extensionElements": {},
    "dmn__tBusinessKnowledgeModel": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tBusinessKnowledgeModel__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "encapsulatedLogic": { type: "dmn__tFunctionDefinition", isArray: false, fromType: "dmn__tBusinessKnowledgeModel", xsdType: "// local type" },
        "variable": { type: "dmn__tInformationItem", isArray: false, fromType: "dmn__tBusinessKnowledgeModel", xsdType: "// local type" },
        "knowledgeRequirement": { type: "dmn__tKnowledgeRequirement", isArray: true, fromType: "dmn__tBusinessKnowledgeModel", xsdType: "// local type" },
        "authorityRequirement": { type: "dmn__tAuthorityRequirement", isArray: true, fromType: "dmn__tBusinessKnowledgeModel", xsdType: "// local type" },
    },
    "dmn__tInputData__extensionElements": {},
    "dmn__tInputData": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tInputData__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "dmn__tInformationItem", isArray: false, fromType: "dmn__tInputData", xsdType: "// local type" },
    },
    "dmn__tKnowledgeSource__extensionElements": {},
    "dmn__tKnowledgeSource": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tKnowledgeSource__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "@_locationURI": { type: "string", isArray: false, fromType: "dmn__tKnowledgeSource", xsdType: "xsd:anyURI" },
        "authorityRequirement": { type: "dmn__tAuthorityRequirement", isArray: true, fromType: "dmn__tKnowledgeSource", xsdType: "// local type" },
        "type": { type: "string", isArray: false, fromType: "dmn__tKnowledgeSource", xsdType: "xsd:string" },
        "owner": { type: "dmn__tDMNElementReference", isArray: false, fromType: "dmn__tKnowledgeSource", xsdType: "// local type" },
    },
    "dmn__tInformationRequirement": {},
    "dmn__tKnowledgeRequirement": {
        "requiredKnowledge": { type: "dmn__tDMNElementReference", isArray: false, fromType: "dmn__tKnowledgeRequirement", xsdType: "// local type" },
    },
    "dmn__tAuthorityRequirement": {},
    "dmn__tExpression__extensionElements": {},
    "dmn__tExpression": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tExpression__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tExpression", xsdType: "xsd:QName" },
    },
    "dmn__tItemDefinition__extensionElements": {},
    "dmn__tItemDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tItemDefinition__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "dmn__tItemDefinition", xsdType: "xsd:anyURI" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "dmn__tItemDefinition", xsdType: "xsd:boolean" },
        "itemComponent": { type: "dmn__tItemDefinition", isArray: true, fromType: "dmn__tItemDefinition", xsdType: "// local type" },
        "typeRef": { type: "string", isArray: false, fromType: "dmn__tItemDefinition", xsdType: "xsd:QName" },
        "allowedValues": { type: "dmn__tUnaryTests", isArray: false, fromType: "dmn__tItemDefinition", xsdType: "// local type" },
    },
    "dmn__tLiteralExpression__extensionElements": {},
    "dmn__tLiteralExpression": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tLiteralExpression__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tExpression", xsdType: "xsd:QName" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "dmn__tLiteralExpression", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "dmn__tLiteralExpression", xsdType: "xsd:string" },
        "importedValues": { type: "dmn__tImportedValues", isArray: false, fromType: "dmn__tLiteralExpression", xsdType: "// local type" },
    },
    "dmn__tInvocation__extensionElements": {},
    "dmn__tInvocation": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tInvocation__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tExpression", xsdType: "xsd:QName" },
        "expression": { type: "dmn__tExpression", isArray: false, fromType: "dmn__tInvocation", xsdType: "// local type" },
        "binding": { type: "dmn__tBinding", isArray: true, fromType: "dmn__tInvocation", xsdType: "// local type" },
    },
    "dmn__tBinding": {
        "parameter": { type: "dmn__tInformationItem", isArray: false, fromType: "dmn__tBinding", xsdType: "// local type" },
        "expression": { type: "dmn__tExpression", isArray: false, fromType: "dmn__tBinding", xsdType: "// local type" },
    },
    "dmn__tInformationItem__extensionElements": {},
    "dmn__tInformationItem": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tInformationItem__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tInformationItem", xsdType: "xsd:QName" },
    },
    "dmn__tDecisionTable__extensionElements": {},
    "dmn__tDecisionTable": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tDecisionTable__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tExpression", xsdType: "xsd:QName" },
        "@_hitPolicy": { type: "dmn__tHitPolicy", isArray: false, fromType: "dmn__tDecisionTable", xsdType: "// local type" },
        "@_aggregation": { type: "dmn__tBuiltinAggregator", isArray: false, fromType: "dmn__tDecisionTable", xsdType: "// local type" },
        "@_preferredOrientation": { type: "dmn__tDecisionTableOrientation", isArray: false, fromType: "dmn__tDecisionTable", xsdType: "// local type" },
        "@_outputLabel": { type: "string", isArray: false, fromType: "dmn__tDecisionTable", xsdType: "xsd:string" },
        "input": { type: "dmn__tInputClause", isArray: true, fromType: "dmn__tDecisionTable", xsdType: "// local type" },
        "output": { type: "dmn__tOutputClause", isArray: true, fromType: "dmn__tDecisionTable", xsdType: "// local type" },
        "rule": { type: "dmn__tDecisionRule", isArray: true, fromType: "dmn__tDecisionTable", xsdType: "// local type" },
    },
    "dmn__tDecisionRule__extensionElements": {},
    "dmn__tDecisionRule": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tDecisionRule__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "inputEntry": { type: "dmn__tUnaryTests", isArray: true, fromType: "dmn__tDecisionRule", xsdType: "// local type" },
        "outputEntry": { type: "dmn__tLiteralExpression", isArray: true, fromType: "dmn__tDecisionRule", xsdType: "// local type" },
    },
    "dmn__tImportedValues": {
        "@_namespace": { type: "string", isArray: false, fromType: "dmn__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "dmn__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "dmn__tImport", xsdType: "xsd:anyURI" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "dmn__tImportedValues", xsdType: "xsd:anyURI" },
        "importedElement": { type: "string", isArray: false, fromType: "dmn__tImportedValues", xsdType: "xsd:string" },
    },
    "dmn__tArtifact__extensionElements": {},
    "dmn__tArtifact": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tArtifact__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
    },
    "dmn__tTextAnnotation__extensionElements": {},
    "dmn__tTextAnnotation": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tTextAnnotation__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_textFormat": { type: "string", isArray: false, fromType: "dmn__tTextAnnotation", xsdType: "xsd:string" },
        "text": { type: "string", isArray: false, fromType: "dmn__tTextAnnotation", xsdType: "xsd:string" },
    },
    "dmn__tAssociation__extensionElements": {},
    "dmn__tAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tAssociation__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_associationDirection": { type: "dmn__tAssociationDirection", isArray: false, fromType: "dmn__tAssociation", xsdType: "// local type" },
        "sourceRef": { type: "dmn__tDMNElementReference", isArray: false, fromType: "dmn__tAssociation", xsdType: "// local type" },
        "targetRef": { type: "dmn__tDMNElementReference", isArray: false, fromType: "dmn__tAssociation", xsdType: "// local type" },
    },
    "dmn__tOutputClause__extensionElements": {},
    "dmn__tOutputClause": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tOutputClause__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tOutputClause", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tOutputClause", xsdType: "xsd:QName" },
        "outputValues": { type: "dmn__tUnaryTests", isArray: false, fromType: "dmn__tOutputClause", xsdType: "// local type" },
        "defaultOutputEntry": { type: "dmn__tLiteralExpression", isArray: false, fromType: "dmn__tOutputClause", xsdType: "// local type" },
    },
    "dmn__tInputClause__extensionElements": {},
    "dmn__tInputClause": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tInputClause__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "inputExpression": { type: "dmn__tLiteralExpression", isArray: false, fromType: "dmn__tInputClause", xsdType: "// local type" },
        "inputValues": { type: "dmn__tUnaryTests", isArray: false, fromType: "dmn__tInputClause", xsdType: "// local type" },
    },
    "dmn__tContext__extensionElements": {},
    "dmn__tContext": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tContext__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tExpression", xsdType: "xsd:QName" },
        "contextEntry": { type: "dmn__tContextEntry", isArray: true, fromType: "dmn__tContext", xsdType: "// local type" },
    },
    "dmn__tContextEntry": {
        "variable": { type: "dmn__tInformationItem", isArray: false, fromType: "dmn__tContextEntry", xsdType: "// local type" },
        "expression": { type: "dmn__tExpression", isArray: false, fromType: "dmn__tContextEntry", xsdType: "// local type" },
    },
    "dmn__tFunctionDefinition__extensionElements": {},
    "dmn__tFunctionDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tFunctionDefinition__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tExpression", xsdType: "xsd:QName" },
        "formalParameter": { type: "dmn__tInformationItem", isArray: true, fromType: "dmn__tFunctionDefinition", xsdType: "// local type" },
        "expression": { type: "dmn__tExpression", isArray: false, fromType: "dmn__tFunctionDefinition", xsdType: "// local type" },
    },
    "dmn__tRelation__extensionElements": {},
    "dmn__tRelation": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tRelation__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tExpression", xsdType: "xsd:QName" },
        "column": { type: "dmn__tInformationItem", isArray: true, fromType: "dmn__tRelation", xsdType: "// local type" },
        "row": { type: "dmn__tList", isArray: true, fromType: "dmn__tRelation", xsdType: "// local type" },
    },
    "dmn__tList__extensionElements": {},
    "dmn__tList": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tList__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "dmn__tExpression", xsdType: "xsd:QName" },
        "expression": { type: "dmn__tExpression", isArray: true, fromType: "dmn__tList", xsdType: "// local type" },
    },
    "dmn__tUnaryTests__extensionElements": {},
    "dmn__tUnaryTests": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tUnaryTests__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "dmn__tUnaryTests", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "dmn__tUnaryTests", xsdType: "xsd:string" },
    },
    "dmn__tNamedElement__extensionElements": {},
    "dmn__tNamedElement": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tNamedElement__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
    },
    "dmn__tDecisionService__extensionElements": {},
    "dmn__tDecisionService": {
        "@_id": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "dmn__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "dmn__tDecisionService__extensionElements", isArray: false, fromType: "dmn__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "dmn__tNamedElement", xsdType: "xsd:string" },
        "outputDecision": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecisionService", xsdType: "// local type" },
        "encapsulatedDecision": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecisionService", xsdType: "// local type" },
        "inputDecision": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecisionService", xsdType: "// local type" },
        "inputData": { type: "dmn__tDMNElementReference", isArray: true, fromType: "dmn__tDecisionService", xsdType: "// local type" },
    },
};
//# sourceMappingURL=meta.js.map