import { getNewDmnIdRandomizer } from "../idRandomizer/dmnIdRandomizer";
export function normalize(model) {
    getNewDmnIdRandomizer()
        .ack({
        json: model.definitions.drgElement,
        type: "DMN15__tDefinitions",
        attr: "drgElement",
    })
        .ack({
        json: model.definitions.artifact,
        type: "DMN15__tDefinitions",
        attr: "artifact",
    })
        .ack({
        json: model.definitions["dmndi:DMNDI"],
        type: "DMN15__tDefinitions",
        attr: "dmndi:DMNDI",
    })
        .ack({
        json: model.definitions.import,
        type: "DMN15__tDefinitions",
        attr: "import",
    })
        .ack({
        json: model.definitions.itemDefinition,
        type: "DMN15__tDefinitions",
        attr: "itemDefinition",
    })
        .randomize({ skipAlreadyAttributedIds: true });
    const normalizedModel = model;
    addMissingImportNamespaces(normalizedModel.definitions);
    return normalizedModel;
}
function addMissingImportNamespaces(definitions) {
    if (definitions.import === undefined) {
        return;
    }
    const definedNamespaces = new Set(Object.keys(definitions)
        .filter((keys) => String(keys).startsWith("@_xmlns:"))
        .map((xmlnsKey) => definitions[xmlnsKey]));
    let includedIndex = 0;
    for (let index = 0; index < definitions.import.length; index++) {
        const importedModelNamespace = definitions.import[index]["@_namespace"];
        if (definedNamespaces.has(importedModelNamespace)) {
            continue;
        }
        while (definitions[`@_xmlns:included${includedIndex}`]) {
            includedIndex++;
        }
        definitions[`@_xmlns:included${includedIndex}`] = importedModelNamespace;
    }
}
//# sourceMappingURL=normalize.js.map