import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import PlusIcon from "@patternfly/react-icons/dist/js/icons/plus-icon";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { BeeTableCoordinatesContextProvider, useBeeTableSelectableCell, useBeeTableSelectableCellRef, } from "../../selection/BeeTableSelectionContext";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
import { InsertRowColumnsDirection } from "../../api";
export function BeeTableTh({ forwardRef, onColumnAdded, children, className, thProps, onClick, onHeaderKeyUp, columnIndex, columnKey, rowIndex, rowSpan, groupType, column, isLastLevelColumn, shouldShowColumnsInlineControls: shouldShowRowsInlineControls, isReadOnly, }) {
    var _a;
    const [hoverInfo, setHoverInfo] = useState({ isHovered: false });
    const onAddColumnButtonClick = useCallback((e) => {
        e.stopPropagation();
        if (!hoverInfo.isHovered) {
            return;
        }
        onColumnAdded === null || onColumnAdded === void 0 ? void 0 : onColumnAdded({
            beforeIndex: hoverInfo.part === "left" ? columnIndex - 1 : columnIndex,
            groupType: groupType,
            columnsCount: 1,
            insertDirection: hoverInfo.part === "left" ? InsertRowColumnsDirection.BelowOrLeft : InsertRowColumnsDirection.AboveOrRight,
            currentIndex: columnIndex,
        });
        if (hoverInfo.part === "left") {
            setHoverInfo({ isHovered: false });
        }
    }, [columnIndex, groupType, hoverInfo, onColumnAdded]);
    const { isActive } = useBeeTableSelectableCellRef(rowIndex, columnIndex, undefined);
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            if (column.isRowIndexColumn || groupType === "annotation") {
                beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject("");
            }
            else {
                beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(columnKey);
            }
        }
    }, [beeGwtService, column.isRowIndexColumn, columnKey, groupType, isActive]);
    const _thRef = useRef(null);
    const thRef = forwardRef !== null && forwardRef !== void 0 ? forwardRef : _thRef;
    useEffect(() => {
        function onEnter(e) {
            e.stopPropagation();
            setHoverInfo((prev) => getHoverInfo(e, th));
        }
        function onMove(e) {
            setHoverInfo((prev) => getHoverInfo(e, th));
        }
        function onLeave() {
            setHoverInfo((prev) => ({ isHovered: false }));
        }
        const th = thRef.current;
        th === null || th === void 0 ? void 0 : th.addEventListener("mouseenter", onEnter);
        th === null || th === void 0 ? void 0 : th.addEventListener("mousemove", onMove);
        th === null || th === void 0 ? void 0 : th.addEventListener("mouseleave", onLeave);
        return () => {
            th === null || th === void 0 ? void 0 : th.removeEventListener("mouseleave", onLeave);
            th === null || th === void 0 ? void 0 : th.removeEventListener("mousemove", onMove);
            th === null || th === void 0 ? void 0 : th.removeEventListener("mouseenter", onEnter);
        };
    }, [thRef]);
    const addColumButtonStyle = useMemo(() => hoverInfo.isHovered && hoverInfo.part === "left"
        ? {
            left: "-9px",
        }
        : {
            right: "-10px",
        }, [hoverInfo]);
    const { cssClasses, onMouseDown, onDoubleClick } = useBeeTableSelectableCell(thRef, rowIndex, columnIndex, undefined, useCallback(() => {
        if (column.dataType) {
            return `${column.label} (${column.dataType})`;
        }
        else if (!column.isInlineEditable) {
            return column.label;
        }
        else {
            return "";
        }
    }, [column.dataType, column.isInlineEditable, column.label]));
    const coordinates = useMemo(() => ({
        rowIndex,
        columnIndex,
    }), [columnIndex, rowIndex]);
    return (_jsx(BeeTableCoordinatesContextProvider, { coordinates: coordinates, children: _jsxs("th", { rowSpan: rowSpan, ...thProps, style: { ...thProps.style, display: "table-cell" }, ref: thRef, onMouseDown: onMouseDown, onDoubleClick: isReadOnly ? undefined : onDoubleClick, onClick: onClick, onKeyUp: isReadOnly ? undefined : onHeaderKeyUp, className: `${className} ${cssClasses}`, tabIndex: -1, "data-testid": `kie-tools--bee--table-header-${(_a = column.groupType) !== null && _a !== void 0 ? _a : "undefined"}`, children: [children, !isReadOnly && hoverInfo.isHovered && onColumnAdded && isLastLevelColumn && shouldShowRowsInlineControls && (_jsx("div", { onMouseDown: (e) => e.stopPropagation(), onDoubleClick: (e) => e.stopPropagation(), onClick: onAddColumnButtonClick, className: "add-column-button", style: addColumButtonStyle, children: _jsx(PlusIcon, { size: "sm" }) }))] }) }));
}
export function getHoverInfo(e, elem) {
    const rect = elem.getBoundingClientRect();
    const localX = e.clientX - rect.left;
    const part = localX < rect.width / 2 ? "left" : "right";
    return { isHovered: true, part };
}
//# sourceMappingURL=BeeTableTh.js.map