import { BoxedFunctionKind } from "../api/BoxedExpression";
import { BEE_TABLE_ROW_INDEX_COLUMN_WIDTH, CONDITIONAL_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, CONDITIONAL_EXPRESSION_EXTRA_WIDTH, CONDITIONAL_EXPRESSION_LABEL_COLUMN_WIDTH, CONTEXT_ENTRY_EXPRESSION_MIN_WIDTH, CONTEXT_ENTRY_VARIABLE_MIN_WIDTH, CONTEXT_ENTRY_VARIABLE_COLUMN_WIDTH_INDEX, CONTEXT_EXPRESSION_EXTRA_WIDTH, DECISION_TABLE_ANNOTATION_MIN_WIDTH, DECISION_TABLE_INPUT_MIN_WIDTH, DECISION_TABLE_OUTPUT_MIN_WIDTH, DEFAULT_MIN_WIDTH, FEEL_FUNCTION_EXPRESSION_EXTRA_WIDTH, FEEL_FUNCTION_EXPRESSION_MIN_WIDTH, INVOCATION_ARGUMENT_EXPRESSION_MIN_WIDTH, INVOCATION_EXTRA_WIDTH, INVOCATION_PARAMETER_INFO_COLUMN_WIDTH_INDEX, INVOCATION_PARAMETER_MIN_WIDTH, JAVA_FUNCTION_EXPRESSION_EXTRA_WIDTH, JAVA_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH, JAVA_FUNCTION_EXPRESSION_VALUES_COLUMN_WIDTH_INDEX, JAVA_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH, LIST_EXPRESSION_EXTRA_WIDTH, LIST_EXPRESSION_ITEM_MIN_WIDTH, LITERAL_EXPRESSION_EXTRA_WIDTH, LITERAL_EXPRESSION_MIN_WIDTH, LITERAL_EXPRESSION_WIDTH_INDEX, PMML_FUNCTION_EXPRESSION_EXTRA_WIDTH, PMML_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH, PMML_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH, RELATION_EXPRESSION_COLUMN_MIN_WIDTH, ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH, ITERATOR_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, ITERATOR_EXPRESSION_EXTRA_WIDTH, FILTER_EXPRESSION_MIN_WIDTH, FILTER_EXPRESSION_MATCH_ROW_EXTRA_WIDTH, FILTER_EXPRESSION_EXTRA_WIDTH, } from "./WidthConstants";
export function getExpressionMinWidth(expression) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
    if (!expression || !expression.__$$element) {
        return DEFAULT_MIN_WIDTH;
    }
    else if (expression.__$$element === "literalExpression") {
        return LITERAL_EXPRESSION_MIN_WIDTH + LITERAL_EXPRESSION_EXTRA_WIDTH;
    }
    else if (expression.__$$element === "context") {
        const result = (_a = expression.contextEntry) === null || _a === void 0 ? void 0 : _a.find((e) => !e.variable);
        const nestedExpressions = [...((_b = expression.contextEntry) !== null && _b !== void 0 ? _b : []).map((e) => e.expression), result === null || result === void 0 ? void 0 : result.expression];
        return (CONTEXT_ENTRY_VARIABLE_MIN_WIDTH +
            Math.max(CONTEXT_ENTRY_EXPRESSION_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionMinWidth(e))) +
            CONTEXT_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "invocation") {
        const nestedExpressions = ((_c = expression.binding) !== null && _c !== void 0 ? _c : []).map((e) => e.expression);
        return (INVOCATION_PARAMETER_MIN_WIDTH +
            Math.max(INVOCATION_ARGUMENT_EXPRESSION_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionMinWidth(e))) +
            INVOCATION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "functionDefinition") {
        if (expression["@_kind"] === BoxedFunctionKind.Feel) {
            return (Math.max(FEEL_FUNCTION_EXPRESSION_MIN_WIDTH, ...[expression.expression].map((expression) => getExpressionMinWidth(expression))) + FEEL_FUNCTION_EXPRESSION_EXTRA_WIDTH);
        }
        else if (expression["@_kind"] === BoxedFunctionKind.Java) {
            return (JAVA_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH +
                JAVA_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH +
                JAVA_FUNCTION_EXPRESSION_EXTRA_WIDTH);
        }
        else if (expression["@_kind"] === BoxedFunctionKind.Pmml) {
            return (PMML_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH +
                PMML_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH +
                PMML_FUNCTION_EXPRESSION_EXTRA_WIDTH);
        }
        else {
            throw new Error("Should never get here");
        }
    }
    else if (expression.__$$element === "relation") {
        return (BEE_TABLE_ROW_INDEX_COLUMN_WIDTH +
            ((_e = (_d = expression.column) === null || _d === void 0 ? void 0 : _d.length) !== null && _e !== void 0 ? _e : 0) * RELATION_EXPRESSION_COLUMN_MIN_WIDTH);
    }
    else if (expression.__$$element === "decisionTable") {
        return (BEE_TABLE_ROW_INDEX_COLUMN_WIDTH +
            ((_g = (_f = expression.input) === null || _f === void 0 ? void 0 : _f.length) !== null && _g !== void 0 ? _g : 0) * DECISION_TABLE_INPUT_MIN_WIDTH +
            ((_j = (_h = expression.output) === null || _h === void 0 ? void 0 : _h.length) !== null && _j !== void 0 ? _j : 0) * DECISION_TABLE_OUTPUT_MIN_WIDTH +
            ((_l = (_k = expression.annotation) === null || _k === void 0 ? void 0 : _k.length) !== null && _l !== void 0 ? _l : 0) * DECISION_TABLE_ANNOTATION_MIN_WIDTH);
    }
    else if (expression.__$$element === "list") {
        return (Math.max(LIST_EXPRESSION_ITEM_MIN_WIDTH, ...((_m = expression.expression) !== null && _m !== void 0 ? _m : []).map((expression) => getExpressionMinWidth(expression))) + LIST_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "conditional") {
        const nestedExpressions = [expression.if.expression, expression.then.expression, expression.else.expression];
        return (CONDITIONAL_EXPRESSION_LABEL_COLUMN_WIDTH +
            Math.max(CONDITIONAL_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionMinWidth(e))) +
            CONDITIONAL_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "for") {
        const nestedExpressions = [expression.in.expression, expression.return.expression];
        return (ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH +
            Math.max(ITERATOR_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionMinWidth(e))) +
            ITERATOR_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "every" || expression.__$$element === "some") {
        const nestedExpressions = [expression.in.expression, expression.satisfies.expression];
        return (ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH +
            Math.max(ITERATOR_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionMinWidth(e))) +
            ITERATOR_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "filter") {
        const inExpressionWidth = getExpressionMinWidth(expression.in.expression);
        const matchExpressionWidth = getExpressionMinWidth(expression.match.expression) + FILTER_EXPRESSION_MATCH_ROW_EXTRA_WIDTH;
        return (Math.max(FILTER_EXPRESSION_MIN_WIDTH, inExpressionWidth, matchExpressionWidth) + FILTER_EXPRESSION_EXTRA_WIDTH);
    }
    else {
        throw new Error("Shouldn't ever reach this point");
    }
}
export function getExpressionTotalMinWidth(currentWidth, expression, widthsById) {
    var _a, _b, _c, _d;
    if (!expression) {
        return 0;
    }
    if (expression.__$$element === "context") {
        const width = currentWidth +
            ((_a = getWidthAt(CONTEXT_ENTRY_VARIABLE_COLUMN_WIDTH_INDEX, widthsById, expression["@_id"])) !== null && _a !== void 0 ? _a : CONTEXT_ENTRY_VARIABLE_MIN_WIDTH) +
            CONTEXT_EXPRESSION_EXTRA_WIDTH;
        const contextEntriesMaxWidth = ((_b = expression.contextEntry) !== null && _b !== void 0 ? _b : []).reduce((maxWidth, currentExpression) => Math.max(maxWidth, getExpressionTotalMinWidth(width, currentExpression.expression, widthsById)), width);
        return contextEntriesMaxWidth;
    }
    else if (expression.__$$element === "invocation") {
        const width = currentWidth +
            ((_c = getWidthAt(INVOCATION_PARAMETER_INFO_COLUMN_WIDTH_INDEX, widthsById, expression["@_id"])) !== null && _c !== void 0 ? _c : INVOCATION_PARAMETER_MIN_WIDTH) +
            INVOCATION_EXTRA_WIDTH;
        return ((_d = expression.binding) !== null && _d !== void 0 ? _d : []).reduce((maxWidth, currentExpression) => Math.max(maxWidth, getExpressionTotalMinWidth(width, currentExpression.expression, widthsById)), width);
    }
    else {
        return currentWidth + getExpressionMinWidth(expression);
    }
}
export function getExpressionResizingWidth(expression, resizingWidths, widthsById) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
    if (!expression || !expression.__$$element) {
        return getExpressionMinWidth(expression);
    }
    const resizingWidth = (_a = resizingWidths.get(expression["@_id"])) === null || _a === void 0 ? void 0 : _a.value;
    if (expression.__$$element === "literalExpression") {
        return (((_b = resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : getWidthAt(LITERAL_EXPRESSION_WIDTH_INDEX, widthsById, expression["@_id"])) !== null && _b !== void 0 ? _b : LITERAL_EXPRESSION_MIN_WIDTH) + LITERAL_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "relation") {
        const columns = (_c = expression.column) !== null && _c !== void 0 ? _c : [];
        return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : columns.reduce((acc, c, currentIndex) => {
            var _a;
            return (acc + ((_a = getWidthAt(currentIndex + 1, widthsById, expression["@_id"])) !== null && _a !== void 0 ? _a : RELATION_EXPRESSION_COLUMN_MIN_WIDTH));
        }, BEE_TABLE_ROW_INDEX_COLUMN_WIDTH));
    }
    else if (expression.__$$element === "decisionTable") {
        const columns = [...((_d = expression.input) !== null && _d !== void 0 ? _d : []), ...((_e = expression.output) !== null && _e !== void 0 ? _e : []), ...((_f = expression.annotation) !== null && _f !== void 0 ? _f : [])];
        return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : columns.reduce((acc, c, currentIndex) => {
            var _a;
            return (acc + ((_a = getWidthAt(currentIndex + 1, widthsById, expression["@_id"])) !== null && _a !== void 0 ? _a : RELATION_EXPRESSION_COLUMN_MIN_WIDTH));
        }, BEE_TABLE_ROW_INDEX_COLUMN_WIDTH));
    }
    else if (expression.__$$element === "context") {
        const result = (_g = expression.contextEntry) === null || _g === void 0 ? void 0 : _g.find((e) => !e.variable);
        const nestedExpressions = [...((_h = expression.contextEntry) !== null && _h !== void 0 ? _h : []).map((e) => e.expression), result === null || result === void 0 ? void 0 : result.expression];
        return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : ((_j = getWidthAt(CONTEXT_ENTRY_VARIABLE_COLUMN_WIDTH_INDEX, widthsById, expression["@_id"])) !== null && _j !== void 0 ? _j : CONTEXT_ENTRY_VARIABLE_MIN_WIDTH) +
            Math.max(CONTEXT_ENTRY_EXPRESSION_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionResizingWidth(e, resizingWidths, widthsById))) +
            CONTEXT_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "invocation") {
        const nestedExpressions = ((_k = expression.binding) !== null && _k !== void 0 ? _k : []).map((e) => e.expression);
        return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : ((_l = getWidthAt(INVOCATION_PARAMETER_INFO_COLUMN_WIDTH_INDEX, widthsById, expression["@_id"])) !== null && _l !== void 0 ? _l : INVOCATION_PARAMETER_MIN_WIDTH) +
            Math.max(INVOCATION_ARGUMENT_EXPRESSION_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionResizingWidth(e, resizingWidths, widthsById))) +
            INVOCATION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "functionDefinition") {
        if (expression["@_kind"] === BoxedFunctionKind.Feel) {
            return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : Math.max(FEEL_FUNCTION_EXPRESSION_MIN_WIDTH, ...[expression.expression].map((expression) => getExpressionResizingWidth(expression, resizingWidths, widthsById))) + FEEL_FUNCTION_EXPRESSION_EXTRA_WIDTH);
        }
        else if (expression["@_kind"] === BoxedFunctionKind.Java) {
            return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : JAVA_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH +
                ((_m = getWidthAt(JAVA_FUNCTION_EXPRESSION_VALUES_COLUMN_WIDTH_INDEX, widthsById, expression["@_id"])) !== null && _m !== void 0 ? _m : JAVA_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH) +
                JAVA_FUNCTION_EXPRESSION_EXTRA_WIDTH);
        }
        else if (expression["@_kind"] === BoxedFunctionKind.Pmml) {
            return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : PMML_FUNCTION_EXPRESSION_LABEL_MIN_WIDTH +
                PMML_FUNCTION_EXPRESSION_VALUES_MIN_WIDTH +
                PMML_FUNCTION_EXPRESSION_EXTRA_WIDTH);
        }
        else {
            throw new Error("Should never get here");
        }
    }
    else if (expression.__$$element === "list") {
        return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : Math.max(LIST_EXPRESSION_ITEM_MIN_WIDTH, ...((_o = expression.expression) !== null && _o !== void 0 ? _o : []).map((expression) => getExpressionResizingWidth(expression, resizingWidths, widthsById))) + LIST_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "conditional") {
        const nestedExpressions = [expression.if.expression, expression.then.expression, expression.else.expression];
        return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : CONDITIONAL_EXPRESSION_LABEL_COLUMN_WIDTH +
            Math.max(CONDITIONAL_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionResizingWidth(e, resizingWidths, widthsById))) +
            CONDITIONAL_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "for") {
        const nestedExpressions = [expression.in.expression, expression.return.expression];
        return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH +
            Math.max(ITERATOR_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionResizingWidth(e, resizingWidths, widthsById))) +
            ITERATOR_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "every" || expression.__$$element === "some") {
        const nestedExpressions = [expression.in.expression, expression.satisfies.expression];
        return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : ITERATOR_EXPRESSION_LABEL_COLUMN_WIDTH +
            Math.max(ITERATOR_EXPRESSION_CLAUSE_COLUMN_MIN_WIDTH, ...nestedExpressions.map((e) => getExpressionResizingWidth(e, resizingWidths, widthsById))) +
            ITERATOR_EXPRESSION_EXTRA_WIDTH);
    }
    else if (expression.__$$element === "filter") {
        const inExpressionWidth = getExpressionResizingWidth(expression.in.expression, resizingWidths, widthsById);
        const matchExpressionWidth = getExpressionResizingWidth(expression.match.expression, resizingWidths, widthsById) +
            FILTER_EXPRESSION_MATCH_ROW_EXTRA_WIDTH;
        return (resizingWidth !== null && resizingWidth !== void 0 ? resizingWidth : Math.max(FILTER_EXPRESSION_MIN_WIDTH, inExpressionWidth, matchExpressionWidth) + FILTER_EXPRESSION_EXTRA_WIDTH);
    }
    else {
        throw new Error(`Can't determine resizing width for expression of unknown type '${expression.__$$element}'`);
    }
}
function getWidthAt(index, widthsById, expressionId) {
    const widths = widthsById.get(expressionId);
    if (!widths || widths.length <= index) {
        return undefined;
    }
    return widths[index];
}
//# sourceMappingURL=WidthMaths.js.map