import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { EmptyState, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { CubesIcon } from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { OutlinedTrashAltIcon } from "@patternfly/react-icons/dist/js/icons/outlined-trash-alt-icon";
import { useCallback } from "react";
import { Action, generateUuid, getNextAvailablePrefixedName } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { DataTypeSelector } from "../../expressionVariable/DataTypeSelector";
import "./ParametersPopover.css";
export const ParametersPopover = ({ parameters }) => {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const addParameter = useCallback((e) => {
        e.stopPropagation();
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b;
                const newParameters = [
                    ...((_a = prev.formalParameter) !== null && _a !== void 0 ? _a : []),
                    {
                        "@_id": generateUuid(),
                        "@_name": getNextAvailablePrefixedName(((_b = prev.formalParameter) !== null && _b !== void 0 ? _b : []).map((p) => p["@_name"]), "p"),
                        "@_typeRef": undefined,
                    },
                ];
                const ret = {
                    ...prev,
                    formalParameter: newParameters,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.FunctionParameterAdded },
        });
    }, [setExpression]);
    return (_jsx("div", { className: "parameters-editor", onMouseDown: (e) => e.stopPropagation(), children: parameters.length ? (_jsxs(_Fragment, { children: [_jsx(Button, { variant: "tertiary", onClickCapture: addParameter, className: "add-parameter", children: i18n.addParameter }), _jsx("div", { className: "parameters-container", children: parameters.map((parameter, index) => (_jsx(ParameterEntry, { parameter: parameter, index: index }, index))) })] })) : (_jsx("div", { className: "parameters-container-empty", children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, { headingLevel: "h4", children: i18n.noParametersDefined }), _jsx(Button, { variant: "primary", onClickCapture: addParameter, children: i18n.addParameter })] }) })) }));
};
function ParameterEntry({ parameter, index }) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onNameChange = useCallback((e) => {
        var _a;
        e.stopPropagation();
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newParameters = [...((_a = prev.formalParameter) !== null && _a !== void 0 ? _a : [])];
                newParameters[index] = {
                    ...newParameters[index],
                    "@_name": e.target.value,
                };
                const ret = {
                    ...prev,
                    formalParameter: newParameters,
                };
                return ret;
            },
            expressionChangedArgs: {
                action: Action.VariableChanged,
                variableUuid: (_a = parameter["@_id"]) !== null && _a !== void 0 ? _a : "",
                nameChange: {
                    from: parameter["@_name"],
                    to: e.target.value,
                },
            },
        });
    }, [index, parameter, setExpression]);
    const onDataTypeChange = useCallback((typeRef) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newParameters = [...((_a = prev.formalParameter) !== null && _a !== void 0 ? _a : [])];
                newParameters[index] = {
                    ...newParameters[index],
                    "@_typeRef": typeRef,
                };
                const ret = {
                    ...prev,
                    formalParameter: newParameters,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.FunctionParameterTypeChanged },
        });
    }, [index, setExpression]);
    const onParameterRemove = useCallback((e) => {
        e.stopPropagation();
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newParameters = [...((_a = prev.formalParameter) !== null && _a !== void 0 ? _a : [])];
                newParameters.splice(index, 1);
                const ret = {
                    ...prev,
                    formalParameter: newParameters,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.FunctionParameterRemoved },
        });
    }, [index, setExpression]);
    return (_jsxs("div", { className: "parameter-entry", children: [_jsx("input", { className: "parameter-name", type: "text", onBlur: onNameChange, placeholder: "Parameter Name", defaultValue: parameter["@_name"] }), _jsx(DataTypeSelector, { value: parameter["@_typeRef"], onChange: onDataTypeChange, menuAppendTo: "parent" }), _jsx(Button, { variant: "danger", className: "delete-parameter", icon: _jsx(OutlinedTrashAltIcon, {}), iconPosition: "left", onClickCapture: onParameterRemove })] }, `${parameter["@_name"]}_${index}`));
}
//# sourceMappingURL=ParametersPopover.js.map