import { ParserRuleContext } from "antlr4";
import { KeyStringContext } from "./generated-parser/FEEL_1_1Parser";
import { IdentifierSymbol } from "./IdentifierSymbol";
import { ScopeImpl } from "./ScopeImpl";
import { NameQueue } from "./NameQueue";
import { FeelIdentifiedSymbol } from "../FeelIdentifiedSymbol";
import { Scopes } from "./Scopes";
import { ReservedWords } from "../ReservedWords";
import { FeelSyntacticSymbolNature } from "../FeelSyntacticSymbolNature";
import { MapBackedType } from "./MapBackedType";
import { FunctionSymbol } from "./FunctionSymbol";
export class ParserHelper {
    constructor() {
        this.dynamicResolution = 0;
        this.scopes = new Scopes();
        this.currentName = new NameQueue();
        this.currentName.push("<local>");
        this.currentScope = this.scopes.getGlobalScope();
        this._variables = new Array();
        this._availableSymbols = new Array();
    }
    get availableSymbols() {
        return this._availableSymbols;
    }
    get variables() {
        return this._variables;
    }
    pushScope(type, allowDynamicVariables) {
        this.currentScope = new ScopeImpl(this.currentName.peek(), this.currentScope, type, allowDynamicVariables);
    }
    popScope() {
        var _a, _b;
        this.currentScope = (_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.getParentScope();
        if ((_b = this.currentScope) === null || _b === void 0 ? void 0 : _b.allowDynamicVariables) {
            this.currentScope = this.currentScope.getParentScope();
        }
    }
    enableDynamicResolution() {
        this.dynamicResolution++;
    }
    disableDynamicResolution() {
        if (this.dynamicResolution > 0) {
            this.dynamicResolution--;
        }
    }
    isFeatDMN12EnhancedForLoopEnabled() {
        return true;
    }
    startVariable(t) {
        var _a;
        (_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.start(t.text);
    }
    popName() {
        this.currentName.pop();
    }
    pushName(ctx) {
        if (ctx instanceof ParserRuleContext) {
            this.currentName.push(this.getName(ctx));
        }
        else {
            this.currentName.push(ctx);
        }
    }
    getName(ctx) {
        const key = this.getOriginalText(ctx);
        if (ctx instanceof KeyStringContext) {
            return key;
        }
        return key;
    }
    defineVariable(variable, type, variableType, variableSource, allowDynamicVariables) {
        var _a, _b, _c;
        const variableSymbol = new IdentifierSymbol(variable instanceof ParserRuleContext ? this.getName(variable) : variable, type, variableType, variableSource, allowDynamicVariables);
        if (variableSymbol.getId()) {
            this.availableSymbols.push({
                name: (_a = variableSymbol.getId()) !== null && _a !== void 0 ? _a : "",
                type: (_b = type === null || type === void 0 ? void 0 : type.name) !== null && _b !== void 0 ? _b : "undefined-type",
            });
        }
        (_c = this.currentScope) === null || _c === void 0 ? void 0 : _c.define(variableSymbol);
    }
    dismissScope() {
        var _a;
        if (((_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.getType()) != null && this.currentScope.getType() === undefined) {
            this.disableDynamicResolution();
        }
        this.popScope();
    }
    recoverScope(name) {
        var _a, _b, _c;
        if (!name) {
            return;
        }
        const scopeName = name.replaceAll("\n", "");
        const s = (_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.getChildScopes().get(scopeName);
        if (s != null) {
            this.currentScope = s;
        }
        else {
            const resolved = (_b = this.currentScope) === null || _b === void 0 ? void 0 : _b.resolve(scopeName);
            const scopeType = resolved === null || resolved === void 0 ? void 0 : resolved.getType();
            if (resolved != null && scopeType instanceof MapBackedType) {
                this.pushScope(scopeType);
                for (const f of scopeType.properties) {
                    (_c = this.currentScope) === null || _c === void 0 ? void 0 : _c.define(new IdentifierSymbol(f[0], f[1], FeelSyntacticSymbolNature.GlobalVariable, f[1].source));
                }
            }
            else {
                this.pushScope();
            }
        }
    }
    followUp(token, isPredict) {
        var _a, _b;
        const dynamicResolutionResult = this.isDynamicResolution();
        const follow = dynamicResolutionResult || ((_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.followUp(token.text, isPredict));
        if (dynamicResolutionResult && !isPredict) {
            (_b = this.currentScope) === null || _b === void 0 ? void 0 : _b.followUp(token.text, isPredict);
        }
        return follow !== null && follow !== void 0 ? follow : false;
    }
    isDynamicResolution() {
        return this.dynamicResolution > 0;
    }
    validateVariable(_n1, qn, name) {
        var _a, _b, _c, _d, _e, _f, _g;
        const start = _n1.start.start;
        const end = (_b = (_a = _n1.stop) === null || _a === void 0 ? void 0 : _a.stop) !== null && _b !== void 0 ? _b : 0;
        const length = end - start + 1;
        const startLine = _n1.start.line - 1;
        const endLine = ((_c = _n1.stop) === null || _c === void 0 ? void 0 : _c.line) !== undefined ? _n1.stop.line - 1 : startLine;
        const variableName = name.replaceAll("\r\n", " ").replaceAll("\n", " ").replace(/\s\s+/g, " ");
        if ((_d = this.currentScope) === null || _d === void 0 ? void 0 : _d.getChildScopes().has(variableName)) {
            this.variables.push(new FeelIdentifiedSymbol(start, length, startLine, endLine, FeelSyntacticSymbolNature.GlobalVariable, variableName));
        }
        else {
            const symbol = (_e = this.currentScope) === null || _e === void 0 ? void 0 : _e.resolve(variableName);
            if (symbol) {
                if (symbol instanceof IdentifierSymbol) {
                    const scopeSymbols = [];
                    if (symbol.getType() instanceof MapBackedType) {
                        const map = symbol.getType();
                        for (const [key, value] of map.properties) {
                            scopeSymbols.push({
                                name: key,
                                type: (_f = value.typeRef) !== null && _f !== void 0 ? _f : value.name,
                            });
                        }
                    }
                    if (symbol.allowDynamicVariables) {
                        this.pushScope(undefined, true);
                    }
                    this.variables.push(new FeelIdentifiedSymbol(start, length, startLine, endLine, (_g = symbol.symbolType) !== null && _g !== void 0 ? _g : FeelSyntacticSymbolNature.GlobalVariable, variableName, scopeSymbols, symbol.symbolSource));
                }
                else if (!(symbol instanceof FunctionSymbol)) {
                    this.variables.push(new FeelIdentifiedSymbol(start, length, startLine, endLine, FeelSyntacticSymbolNature.GlobalVariable, variableName));
                }
            }
            else {
                if (!ReservedWords.FeelFunctions.has(variableName) && !ReservedWords.FeelKeywords.has(variableName)) {
                    this.variables.push(new FeelIdentifiedSymbol(start, length, startLine, endLine, FeelSyntacticSymbolNature.Unknown, variableName));
                }
            }
        }
    }
    getOriginalText(ctx) {
        var _a, _b;
        const a = ctx.start.start;
        const b = (_b = (_a = ctx.stop) === null || _a === void 0 ? void 0 : _a.stop) !== null && _b !== void 0 ? _b : 0;
        return ctx.start.getInputStream().getText(a, b);
    }
    fphEnd(count) {
        return count;
    }
    fphStart(_n1, param2) {
        return 0;
    }
}
//# sourceMappingURL=ParserHelper.js.map