import { FeelSyntacticSymbolNature } from "./FeelSyntacticSymbolNature";
import { generateUuid } from "../Uuid";
export class BuiltInTypes {
}
BuiltInTypes.Number = {
    uuid: generateUuid(),
    name: "number",
    typeRef: "number",
    properties: new Map([]),
    source: {
        expressionsThatUseTheIdentifier: new Map(),
        value: "number",
        feelSyntacticSymbolNature: FeelSyntacticSymbolNature.GlobalVariable,
    },
};
BuiltInTypes.Boolean = {
    uuid: generateUuid(),
    name: "boolean",
    typeRef: "boolean",
    properties: new Map([]),
    source: {
        expressionsThatUseTheIdentifier: new Map(),
        value: "boolean",
        feelSyntacticSymbolNature: FeelSyntacticSymbolNature.GlobalVariable,
    },
};
BuiltInTypes.String = {
    uuid: generateUuid(),
    name: "string",
    typeRef: "string",
    properties: new Map([]),
    source: {
        expressionsThatUseTheIdentifier: new Map(),
        value: "string",
        feelSyntacticSymbolNature: FeelSyntacticSymbolNature.GlobalVariable,
    },
};
BuiltInTypes.DaysAndTimeDuration = {
    uuid: generateUuid(),
    name: "days and time duration",
    typeRef: "days and time duration",
    properties: new Map([
        ["days", BuiltInTypes.Number],
        ["hours", BuiltInTypes.Number],
        ["minutes", BuiltInTypes.Number],
        ["seconds", BuiltInTypes.Number],
        ["timezone", BuiltInTypes.String],
    ]),
    source: {
        expressionsThatUseTheIdentifier: new Map(),
        value: "days and time duration",
        feelSyntacticSymbolNature: FeelSyntacticSymbolNature.GlobalVariable,
    },
};
BuiltInTypes.DateAndTime = {
    uuid: generateUuid(),
    name: "date and time",
    typeRef: "date and time",
    properties: new Map([
        ["year", BuiltInTypes.Number],
        ["month", BuiltInTypes.Number],
        ["day", BuiltInTypes.Number],
        ["weekday", BuiltInTypes.Number],
        ["hour", BuiltInTypes.Number],
        ["minute", BuiltInTypes.Number],
        ["second", BuiltInTypes.Number],
        ["time offset", BuiltInTypes.DaysAndTimeDuration],
        ["timezone", BuiltInTypes.String],
    ]),
    source: {
        expressionsThatUseTheIdentifier: new Map(),
        value: "date and time",
        feelSyntacticSymbolNature: FeelSyntacticSymbolNature.GlobalVariable,
    },
};
BuiltInTypes.YearsAndMonthsDuration = {
    uuid: generateUuid(),
    name: "years and months duration",
    typeRef: "years and months duration",
    properties: new Map([
        ["years", BuiltInTypes.Number],
        ["months", BuiltInTypes.Number],
    ]),
    source: {
        expressionsThatUseTheIdentifier: new Map(),
        value: "years and months duration",
        feelSyntacticSymbolNature: FeelSyntacticSymbolNature.GlobalVariable,
    },
};
BuiltInTypes.Time = {
    uuid: generateUuid(),
    name: "time",
    typeRef: "time",
    properties: new Map([
        ["hour", BuiltInTypes.Number],
        ["minute", BuiltInTypes.Number],
        ["second", BuiltInTypes.Number],
        ["time offset", BuiltInTypes.DaysAndTimeDuration],
        ["timezone", BuiltInTypes.String],
    ]),
    source: {
        expressionsThatUseTheIdentifier: new Map(),
        value: "time",
        feelSyntacticSymbolNature: FeelSyntacticSymbolNature.GlobalVariable,
    },
};
BuiltInTypes.Date = {
    uuid: generateUuid(),
    name: "date",
    typeRef: "date",
    properties: new Map([
        ["year", BuiltInTypes.Number],
        ["month", BuiltInTypes.Number],
        ["day", BuiltInTypes.Number],
        ["weekday", BuiltInTypes.Number],
    ]),
    source: {
        expressionsThatUseTheIdentifier: new Map(),
        value: "date",
        feelSyntacticSymbolNature: FeelSyntacticSymbolNature.GlobalVariable,
    },
};
//# sourceMappingURL=BuiltInTypes.js.map