import BpmnPalette from "./BpmnPalette";
import { By } from "selenium-webdriver";
import Editor from "../Editor";
import SideBar from "../SideBar";
class BpmnEditor extends Editor {
    async dragAndDropStartEventToCanvas() {
        const bpmnPalette = await this.getBpmnPalette();
        await bpmnPalette.dragAndDropStartEventToCanvas();
        return await this.clickToCanvas();
    }
    async isPalettePresent() {
        return await this.tools.by(BpmnEditor.PALETTE_LOCATOR).wait(1000).isPresent();
    }
    async getBpmnPalette() {
        const palette = await this.tools.by(BpmnEditor.PALETTE_LOCATOR).getElement();
        return await this.tools.createPageFragment(BpmnPalette, palette);
    }
    async clickToCanvas() {
        const canvas = await this.tools.by(BpmnEditor.CANVAS_LOCATOR).getElement();
        return await canvas.click();
    }
    async getSideBar() {
        const sideBar = await this.tools.by(BpmnEditor.SIDE_BAR_LOCATOR);
        await sideBar.wait(1000).untilPresent();
        return await this.tools.createPageFragment(SideBar, await sideBar.getElement());
    }
}
BpmnEditor.CANVAS_LOCATOR = By.className("canvas-panel");
BpmnEditor.PALETTE_LOCATOR = By.className("kie-palette");
BpmnEditor.SIDE_BAR_LOCATOR = By.className("collapsed-docks-bar-E");
export default BpmnEditor;
//# sourceMappingURL=BpmnEditor.js.map