import { StoreApi, UseBoundStore } from "zustand";
import { WithImmer } from "zustand/middleware/immer";
import { State } from "./Store";
type ExtractState = StoreApi<State> extends {
    getState: () => infer T;
} ? T : never;
export type StoreApiType = UseBoundStore<WithImmer<StoreApi<State>>>;
export declare const DmnEditorStoreApiContext: import("react").Context<StoreApiType>;
export declare function useDmnEditorStore<StateSlice = ExtractState>(selector: (state: State) => StateSlice, equalityFn?: (a: StateSlice, b: StateSlice) => boolean): StateSlice;
export declare function useDmnEditorStoreApi(): StoreApiType;
export {};
//# sourceMappingURL=StoreContext.d.ts.map