import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useState, useMemo } from "react";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Form, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { FontOptions } from "./FontOptions";
import { useDmnEditorStoreApi } from "../store/StoreContext";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { Truncate } from "@patternfly/react-core/dist/js/components/Truncate";
import { PropertiesPanelHeader } from "./PropertiesPanelHeader";
import { ShapeOptions } from "./ShapeOptions";
export function MultipleNodeProperties({ nodeIds }) {
    const [isSectionExpanded, setSectionExpanded] = useState(true);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const size = useMemo(() => nodeIds.length, [nodeIds.length]);
    return (_jsxs(Form, { children: [_jsx(FormSection, { children: _jsx(PropertiesPanelHeader, { fixed: true, isSectionExpanded: isSectionExpanded, toogleSectionExpanded: () => setSectionExpanded((prev) => !prev), title: _jsx(Flex, { justifyContent: { default: "justifyContentCenter" }, children: _jsx(TextContent, { children: _jsx(Text, { component: TextVariants.h4, children: _jsx(Truncate, { content: `Multiple nodes selected (${size})`, position: "middle", trailingNumChars: size.toString().length + 2 }) }) }) }), action: _jsx(Button, { title: "Close", variant: ButtonVariant.plain, onClick: () => {
                            dmnEditorStoreApi.setState((state) => {
                                state.diagram.propertiesPanel.isOpen = false;
                            });
                        }, children: _jsx(TimesIcon, {}) }) }) }), _jsxs(FormSection, { children: [_jsx(FontOptions, { startExpanded: true, nodeIds: nodeIds }), _jsx(ShapeOptions, { startExpanded: true, nodeIds: nodeIds, isDimensioningEnabled: false, isPositioningEnabled: false })] })] }));
}
//# sourceMappingURL=MultipleNodeProperties.js.map