import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo } from "react";
import { useDmnEditorStore } from "../../store/StoreContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { InformationItemCell } from "./InformationItemCell";
export function InvocationInformationItemCell(props) {
    var _a;
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const cellPath = useMemo(() => selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[(selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) - 1], [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath]);
    const rootPath = useMemo(() => { var _a, _b, _c; return (_c = (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get((_b = cellPath === null || cellPath === void 0 ? void 0 : cellPath.root) !== null && _b !== void 0 ? _b : "")) === null || _c === void 0 ? void 0 : _c.expressionPath; }, [cellPath === null || cellPath === void 0 ? void 0 : cellPath.root, props.boxedExpressionIndex]);
    const updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    const rootExpressionUpdater = useBoxedExpressionUpdater(rootPath !== null && rootPath !== void 0 ? rootPath : []);
    return (_jsx(_Fragment, { children: _jsx(InformationItemCell, { ...props, onDescriptionChange: (newDescription) => {
                updater((dmnObject) => {
                    var _a;
                    (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                    dmnObject.description.__$$text = newDescription;
                });
            }, onNameChange: (newName) => {
                updater((dmnObject) => {
                    dmnObject["@_name"] = newName;
                });
            }, onTypeRefChange: (newTypeRef) => {
                updater((dmnObject) => {
                    dmnObject["@_typeRef"] = newTypeRef;
                });
                rootExpressionUpdater((dmnObject) => {
                    var _a;
                    if ((cellPath === null || cellPath === void 0 ? void 0 : cellPath.type) === "invocation") {
                        const expression = dmnObject.binding[(_a = cellPath.row) !== null && _a !== void 0 ? _a : 0].expression;
                        if (expression) {
                            expression["@_typeRef"] = newTypeRef;
                        }
                    }
                });
            } }) }));
}
//# sourceMappingURL=InvocationInformationItemCell.js.map