import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { DrawerActions, DrawerCloseButton, DrawerHead, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { buildXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { useMemo } from "react";
import { SingleNodeProperties } from "./SingleNodeProperties";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { getOperatingSystem, OperatingSystem } from "@kie-tools-core/operating-system";
export function BeePropertiesPanel() {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { selectedObjectId, activeDrgElementId } = useDmnEditorStore((s) => s.boxedExpressionEditor);
    const { externalModelsByNamespace } = useExternalModels();
    const node = useDmnEditorStore((s) => activeDrgElementId
        ? s
            .computed(s)
            .getDiagramData(externalModelsByNamespace)
            .nodesById.get(buildXmlHref({ id: activeDrgElementId }))
        : undefined);
    const shouldDisplayDecisionOrBkmProps = useMemo(() => selectedObjectId === undefined || (selectedObjectId && selectedObjectId === activeDrgElementId), [activeDrgElementId, selectedObjectId]);
    return (_jsx(_Fragment, { children: node && (_jsx(DrawerPanelContent, { isResizable: true, minSize: "300px", defaultSize: "500px", onKeyDown: (e) => {
                if (!(getOperatingSystem() === OperatingSystem.MACOS && e.metaKey)) {
                    e.stopPropagation();
                }
            }, children: _jsxs(DrawerHead, { children: [shouldDisplayDecisionOrBkmProps && _jsx(SingleNodeProperties, { nodeId: node.id }), !shouldDisplayDecisionOrBkmProps && selectedObjectId === "" && _jsx("div", { children: `Nothing to show` }), !shouldDisplayDecisionOrBkmProps && selectedObjectId !== "" && _jsx("div", { children: selectedObjectId }), _jsx(DrawerActions, { children: _jsx(DrawerCloseButton, { onClick: () => {
                                dmnEditorStoreApi.setState((state) => {
                                    state.boxedExpressionEditor.propertiesPanel.isOpen = false;
                                });
                            } }) })] }) })) }));
}
//# sourceMappingURL=BeePropertiesPanel.js.map