import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { buildXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { NodeNature, nodeNatures } from "./NodeNature";
import { addOrGetDrd as getDefaultDiagram } from "./addOrGetDrd";
import { getCentralizedDecisionServiceDividerLine } from "./updateDecisionServiceDividerLine";
import { repopulateInputDataAndDecisionsOnAllDecisionServices } from "./repopulateInputDataAndDecisionsOnDecisionService";
export function addStandaloneNode({ definitions, drdIndex, newNode, externalModelsByNamespace, }) {
    var _a, _b, _c, _d;
    const newNodeId = generateUuid();
    const nature = nodeNatures[newNode.type];
    if (nature === NodeNature.DRG_ELEMENT) {
        (_a = definitions.drgElement) !== null && _a !== void 0 ? _a : (definitions.drgElement = []);
        const variableBase = {
            "@_id": generateUuid(),
            "@_typeRef": undefined,
        };
        (_b = definitions.drgElement) === null || _b === void 0 ? void 0 : _b.push(switchExpression(newNode.type, {
            [NODE_TYPES.bkm]: {
                __$$element: "businessKnowledgeModel",
                "@_name": "New BKM",
                "@_id": newNodeId,
                variable: {
                    "@_name": "New BKM",
                    ...variableBase,
                },
            },
            [NODE_TYPES.decision]: {
                __$$element: "decision",
                "@_name": "New Decision",
                "@_id": newNodeId,
                variable: {
                    "@_name": "New Decision",
                    ...variableBase,
                },
            },
            [NODE_TYPES.decisionService]: {
                __$$element: "decisionService",
                "@_name": "New Decision Service",
                "@_id": newNodeId,
                variable: {
                    "@_name": "New Decision Service",
                    ...variableBase,
                },
            },
            [NODE_TYPES.inputData]: {
                __$$element: "inputData",
                "@_name": "New Input Data",
                "@_id": newNodeId,
                variable: {
                    "@_name": "New Input Data",
                    ...variableBase,
                },
            },
            [NODE_TYPES.knowledgeSource]: {
                __$$element: "knowledgeSource",
                "@_name": "New Knowledge Source",
                "@_id": newNodeId,
            },
        }));
    }
    else if (nature === NodeNature.ARTIFACT) {
        (_c = definitions.artifact) !== null && _c !== void 0 ? _c : (definitions.artifact = []);
        (_d = definitions.artifact) === null || _d === void 0 ? void 0 : _d.push(...switchExpression(newNode.type, {
            [NODE_TYPES.textAnnotation]: [
                {
                    "@_id": newNodeId,
                    __$$element: "textAnnotation",
                    text: { __$$text: "New text annotation" },
                },
            ],
            [NODE_TYPES.group]: [
                {
                    "@_id": newNodeId,
                    __$$element: "group",
                    "@_name": "New group",
                },
            ],
        }));
    }
    else {
        throw new Error(`Unknown node usage '${nature}'.`);
    }
    const { diagramElements } = getDefaultDiagram({ definitions, drdIndex });
    const shapeId = generateUuid();
    diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements.push({
        __$$element: "dmndi:DMNShape",
        "@_id": shapeId,
        "@_dmnElementRef": newNodeId,
        "@_isCollapsed": false,
        "@_isListedInputData": false,
        "dc:Bounds": newNode.bounds,
        ...(newNode.type === NODE_TYPES.decisionService
            ? {
                "dmndi:DMNDecisionServiceDividerLine": getCentralizedDecisionServiceDividerLine(newNode.bounds),
            }
            : {}),
    });
    repopulateInputDataAndDecisionsOnAllDecisionServices({ definitions, externalModelsByNamespace });
    return { id: newNodeId, href: buildXmlHref({ id: newNodeId }), shapeId };
}
//# sourceMappingURL=addStandaloneNode.js.map