import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { addOrGetDrd } from "./addOrGetDrd";
import { getCentralizedDecisionServiceDividerLine } from "./updateDecisionServiceDividerLine";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export function addShape({ definitions, drdIndex, nodeType, shape, decisionServiceDividerLineWaypoint: decisionServiceDividerLineWaypoint, }) {
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex });
    diagramElements.push({
        __$$element: "dmndi:DMNShape",
        ...(nodeType === NODE_TYPES.decisionService
            ? {
                "dmndi:DMNDecisionServiceDividerLine": decisionServiceDividerLineWaypoint !== undefined
                    ? { "@_id": generateUuid(), "di:waypoint": [...decisionServiceDividerLineWaypoint] }
                    : getCentralizedDecisionServiceDividerLine(shape["dc:Bounds"]),
            }
            : {}),
        ...shape,
    });
}
//# sourceMappingURL=addShape.js.map