import { snapPoint } from "../SnapGrid";
import { NODE_TYPES } from "./NodeTypes";
import { CONTAINER_NODES_DESIRABLE_PADDING } from "../maths/DmnMaths";
export const MIN_NODE_SIZES = {
    [NODE_TYPES.inputData]: ({ snapGrid, isAlternativeInputDataShape }) => {
        if (isAlternativeInputDataShape) {
            const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid, NODE_MIN_WIDTH / 2, NODE_MIN_HEIGHT + 20);
            return {
                "@_width": snappedMinSize.width,
                "@_height": snappedMinSize.height,
            };
        }
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.decision]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.bkm]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.knowledgeSource]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.decisionService]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid, NODE_MIN_WIDTH + CONTAINER_NODES_DESIRABLE_PADDING * 2, NODE_MIN_HEIGHT * 2 + CONTAINER_NODES_DESIRABLE_PADDING * 2);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.textAnnotation]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid, 200, 60);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.group]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid, NODE_MIN_WIDTH + CONTAINER_NODES_DESIRABLE_PADDING * 2, NODE_MIN_HEIGHT + CONTAINER_NODES_DESIRABLE_PADDING * 2);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.unknown]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
};
export const DEFAULT_NODE_SIZES = {
    [NODE_TYPES.inputData]: ({ snapGrid, isAlternativeInputDataShape }) => {
        if (isAlternativeInputDataShape) {
            const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid, NODE_MIN_WIDTH / 2, NODE_MIN_HEIGHT + 20);
            return {
                "@_width": snappedMinSize.width,
                "@_height": snappedMinSize.height,
            };
        }
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.decision]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.bkm]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.knowledgeSource]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.decisionService]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid, NODE_MIN_WIDTH * 2, NODE_MIN_WIDTH * 2);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.textAnnotation]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid, 200, 200);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.group]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid, NODE_MIN_WIDTH * 2, NODE_MIN_WIDTH * 2);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
    [NODE_TYPES.unknown]: ({ snapGrid }) => {
        const snappedMinSize = MIN_SIZE_FOR_NODES(snapGrid);
        return {
            "@_width": snappedMinSize.width,
            "@_height": snappedMinSize.height,
        };
    },
};
export const DECISION_SERVICE_COLLAPSED_DIMENSIONS = {
    width: 300,
    height: 100,
};
export const NODE_MIN_WIDTH = 160;
export const NODE_MIN_HEIGHT = 80;
const MIN_SIZE_FOR_NODES = (grid, width = NODE_MIN_WIDTH, height = NODE_MIN_HEIGHT) => {
    const snapped = snapPoint(grid, { "@_x": width, "@_y": height }, "ceil");
    return { width: snapped["@_x"], height: snapped["@_y"] };
};
//# sourceMappingURL=DefaultSizes.js.map