import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Popover, PopoverPosition } from "@patternfly/react-core/dist/js/components/Popover";
import { useMemo } from "react";
import { DMN_LATEST_VERSION } from "@kie-tools/dmn-marshaller";
const latestChangelogHref = `https://www.omg.org/spec/DMN/1.5/Beta1/PDF/changebar`;
export function DmnVersionLabel(props) {
    const label = useMemo(() => (_jsx(Label, { style: { cursor: "pointer", position: "absolute", bottom: "8px", left: "calc(50% - 34px)", zIndex: 100 }, children: `DMN ${DMN_LATEST_VERSION}` })), []);
    if (props.version === DMN_LATEST_VERSION) {
        return _jsx(_Fragment, { children: label });
    }
    return (_jsx(Popover, { showClose: false, className: "kie-dmn-editor--version-popover", "aria-label": "DMN version popover", position: PopoverPosition.top, headerContent: _jsx("div", { children: "Version upgraded!" }), bodyContent: _jsxs("div", { children: ["This DMN was originally imported as DMN ", props.version, ", but was converted to DMN ", DMN_LATEST_VERSION, " to enable new features.", _jsxs("a", { href: latestChangelogHref, target: "_blank", children: ["\u00A0", `See what's new on DMN ${DMN_LATEST_VERSION}`, "."] })] }), children: label }));
}
//# sourceMappingURL=DmnVersionLabel.js.map