import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { EditableNodeLabel, useEditableNodeLabel } from "../diagram/nodes/EditableNodeLabel";
import { TypeRefLabel } from "./TypeRefLabel";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { renameItemDefinition } from "../mutations/renameItemDefinition";
import { buildFeelQNameFromNamespace } from "../feel/buildFeelQName";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
import { isIdentifierReferencedInSomeExpression, RefactorConfirmationDialog, } from "../refactor/RefactorConfirmationDialog";
import { isStruct } from "./DataTypeSpec";
export function DataTypeName({ isReadOnly, itemDefinition, isActive, editMode, relativeToNamespace, shouldCommitOnBlur, onGetAllUniqueNames, enableAutoFocusing, }) {
    var _a, _b;
    const { isEditingLabel, setEditingLabel, triggerEditing, triggerEditingIfEnter } = useEditableNodeLabel((enableAutoFocusing !== null && enableAutoFocusing !== void 0 ? enableAutoFocusing : true) ? itemDefinition["@_id"] : undefined);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { externalModelsByNamespace } = useExternalModels();
    const dataType = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).allDataTypesById.get(itemDefinition["@_id"]));
    const importsByNamespace = useDmnEditorStore((s) => s.computed(s).importsByNamespace());
    const feelQNameToDisplay = buildFeelQNameFromNamespace({
        namedElement: itemDefinition,
        importsByNamespace,
        namespace: dataType.namespace,
        relativeToNamespace,
    });
    const externalDmnModelsByNamespaceMap = useDmnEditorStore((s) => s.computed(s).getExternalDmnModelsByNamespaceMap(externalModelsByNamespace));
    const _shouldCommitOnBlur = shouldCommitOnBlur !== null && shouldCommitOnBlur !== void 0 ? shouldCommitOnBlur : true;
    const [isRefactorModalOpen, setIsRefactorModalOpen] = useState(false);
    const [newName, setNewName] = useState("");
    const identifierId = useMemo(() => itemDefinition["@_id"], [itemDefinition]);
    const oldName = useMemo(() => itemDefinition["@_name"], [itemDefinition]);
    const currentName = useMemo(() => {
        if (editMode === "hover") {
            return newName === "" ? feelQNameToDisplay.full : newName;
        }
        else if (editMode === "double-click") {
            return newName === "" ? itemDefinition["@_name"] : newName;
        }
        else {
            throw new Error(`Unknown edit mode in DataTypeName: ${editMode}`);
        }
    }, [editMode, feelQNameToDisplay.full, itemDefinition, newName]);
    const applyRename = useCallback((args) => {
        renameItemDefinition({
            ...args,
            itemDefinitionId: itemDefinition["@_id"],
            externalDmnModelsByNamespaceMap,
        });
    }, [externalDmnModelsByNamespaceMap, itemDefinition]);
    const onRenamed = useCallback((newName) => {
        if (isReadOnly || newName === oldName) {
            return;
        }
        dmnEditorStoreApi.setState((state) => {
            if (isIdentifierReferencedInSomeExpression({
                identifierUuid: identifierId,
                dmnDefinitions: state.dmn.model.definitions,
                externalDmnModelsByNamespaceMap,
            })) {
                setNewName(newName);
                setIsRefactorModalOpen(true);
            }
            else {
                applyRename({
                    definitions: state.dmn.model.definitions,
                    newName,
                    shouldRenameReferencedExpressions: false,
                    allDataTypesById: state.computed(state).getDataTypes(externalModelsByNamespace).allDataTypesById,
                });
            }
        });
    }, [
        applyRename,
        dmnEditorStoreApi,
        externalDmnModelsByNamespaceMap,
        externalModelsByNamespace,
        identifierId,
        isReadOnly,
        oldName,
    ]);
    const confirmRename = useCallback((shouldRenameReferencedExpressions) => {
        setIsRefactorModalOpen(false);
        dmnEditorStoreApi.setState((state) => {
            applyRename({
                definitions: state.dmn.model.definitions,
                newName,
                shouldRenameReferencedExpressions,
                allDataTypesById: state.computed(state).getDataTypes(externalModelsByNamespace).allDataTypesById,
            });
        });
    }, [applyRename, dmnEditorStoreApi, externalModelsByNamespace, newName]);
    return (_jsxs(_Fragment, { children: [_jsx(RefactorConfirmationDialog, { onConfirmExpressionRefactor: () => {
                    confirmRename(true);
                }, onConfirmRenameOnly: () => {
                    confirmRename(false);
                }, isRefactorModalOpen: isRefactorModalOpen, fromName: oldName, toName: newName, onCancel: () => {
                    setNewName("");
                    setIsRefactorModalOpen(false);
                } }), editMode === "hover" && (_jsx(InlineFeelNameInput, { isPlain: true, isReadOnly: isReadOnly, id: itemDefinition["@_id"], shouldCommitOnBlur: _shouldCommitOnBlur, name: currentName, onRenamed: onRenamed, allUniqueNames: onGetAllUniqueNames, enableAutoFocusing: enableAutoFocusing })), editMode === "double-click" && (_jsxs(Flex, { tabIndex: -1, style: isEditingLabel ? { flexGrow: 1 } : {}, flexWrap: { default: "nowrap" }, spaceItems: { default: "spaceItemsNone" }, justifyContent: { default: "justifyContentFlexStart" }, alignItems: { default: "alignItemsCenter" }, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, children: [_jsx(EditableNodeLabel, { truncate: true, enableAutoFocusing: enableAutoFocusing, grow: true, isEditing: isEditingLabel, setEditing: setEditingLabel, onChange: onRenamed, shouldCommitOnBlur: shouldCommitOnBlur, value: currentName, position: "top-left", namedElement: itemDefinition, namedElementQName: {
                            type: "xml-qname",
                            localPart: itemDefinition["@_name"],
                            prefix: feelQNameToDisplay.prefix,
                        }, onGetAllUniqueNames: onGetAllUniqueNames }, itemDefinition["@_id"]), !isEditingLabel && (_jsx(TypeRefLabel, { typeRef: isStruct(itemDefinition) ? "" : (_b = (_a = itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined, isCollection: itemDefinition["@_isCollection"], relativeToNamespace: relativeToNamespace }))] }))] }));
}
//# sourceMappingURL=DataTypeName.js.map