import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo, useState, useCallback, useRef } from "react";
import { ConstraintsExpression } from "./ConstraintsExpression";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import PlusCircleIcon from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import { Draggable, DragAndDrop, useDraggableItemContext } from "../draggable/Draggable";
import TimesIcon from "@patternfly/react-icons/dist/js/icons/times-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export const ENUM_SEPARATOR = ",";
export function ConstraintsEnum({ id, isReadOnly, value, expressionValue, type, typeHelper, onSave, isDisabled, renderOnPropertiesPanel, }) {
    var _a;
    const enumValues = useMemo(() => { var _a; return (_a = isEnum(value, typeHelper.check)) !== null && _a !== void 0 ? _a : [""]; }, [typeHelper.check, value]);
    const [valuesUuid, setValuesUuid] = useState((_a = (enumValues !== null && enumValues !== void 0 ? enumValues : [""])) === null || _a === void 0 ? void 0 : _a.map((_) => generateUuid()));
    const isItemValid = useMemo(() => enumValues.map((value, i, array) => array.filter((e) => e === value).length <= 1), [enumValues]);
    const [focusOwner, setFocusOwner] = useState("");
    const onAdd = useCallback(() => {
        setValuesUuid((prev) => {
            if (prev[enumValues.length] === undefined) {
                const newValuesUuid = [...prev];
                newValuesUuid[enumValues.length] = generateUuid();
                return newValuesUuid;
            }
            return prev;
        });
        onSave(enumValues.join(`${ENUM_SEPARATOR} `) + ENUM_SEPARATOR);
        setFocusOwner("");
    }, [onSave, enumValues]);
    const onRemove = useCallback((index) => {
        const newValues = [...enumValues];
        newValues.splice(index, 1);
        setValuesUuid((prev) => {
            const newUuids = [...prev];
            newUuids.splice(index, 1);
            return newUuids;
        });
        onSave(newValues.join(`${ENUM_SEPARATOR} `));
    }, [enumValues, onSave]);
    const onDragEnd = useCallback((source, dest) => {
        const reordened = [...enumValues];
        const [removed] = reordened.splice(source, 1);
        reordened.splice(dest, 0, removed);
        onSave(reordened.join(`${ENUM_SEPARATOR} `));
    }, [enumValues, onSave]);
    const reorder = useCallback((source, dest) => {
        setValuesUuid((prev) => {
            const reordenedUuid = [...prev];
            const [removedUuid] = reordenedUuid.splice(source, 1);
            reordenedUuid.splice(dest, 0, removedUuid);
            return reordenedUuid;
        });
    }, []);
    const onChangeItem = useCallback((newValue, index) => {
        const newValues = [...enumValues];
        newValues[index] = typeHelper.transform(newValue);
        onSave(newValues.join(`${ENUM_SEPARATOR} `));
    }, [enumValues, onSave, typeHelper]);
    const draggableItem = useCallback((value, index) => {
        var _a;
        return (_jsx(Draggable, { index: index, style: { alignItems: "center" }, handlerStyle: { margin: "0px 10px" }, isDisabled: isReadOnly || isDisabled, children: _jsx("li", { style: { marginLeft: "20px", listStyleType: "initial" }, children: _jsx(EnumElement, { id: `enum-element-${index}`, isDisabled: isReadOnly || isDisabled, initialValue: (_a = typeHelper.recover(value)) !== null && _a !== void 0 ? _a : "", onChange: (newValue) => onChangeItem(newValue, index), onRemove: () => onRemove(index), isValid: isItemValid[index], focusOwner: focusOwner, setFocusOwner: setFocusOwner, typeHelper: typeHelper, onKeyDown: (e) => {
                        if (e.key === "Enter") {
                            onAdd();
                        }
                        if (e.key === ENUM_SEPARATOR) {
                            e.preventDefault();
                        }
                    } }) }) }, valuesUuid[index]));
    }, [focusOwner, isDisabled, isItemValid, isReadOnly, onAdd, onChangeItem, onRemove, typeHelper, valuesUuid]);
    return (_jsxs("div", { children: [_jsx("div", { children: _jsx("div", { style: {
                        display: "flex",
                        flexDirection: "column",
                        gap: "10px",
                        border: "solid 1px lightgray",
                        borderRadius: "4px",
                    }, children: _jsx("ul", { "data-testid": "kie-tools--dmn-editor--enumeration-constraint-list", children: _jsx(DragAndDrop, { reorder: reorder, onDragEnd: onDragEnd, values: enumValues, draggableItem: draggableItem, isDisabled: isDisabled || isReadOnly }) }) }) }), !(isDisabled || isReadOnly) && (_jsx(_Fragment, { children: _jsx(Button, { title: "Add enum value", onClick: () => onAdd(), variant: ButtonVariant.link, icon: _jsx(PlusCircleIcon, {}), style: { paddingTop: "10px", paddingBottom: 0, paddingLeft: 0, paddingRight: 0 }, children: "Add value" }) })), !renderOnPropertiesPanel && (_jsxs(_Fragment, { children: [_jsx("br", {}), _jsx("br", {}), _jsx(ConstraintsExpression, { id: id, isReadOnly: true, value: expressionValue !== null && expressionValue !== void 0 ? expressionValue : "", type: type })] }))] }));
}
function EnumElement({ id, isDisabled, initialValue, isValid, typeHelper, focusOwner, setFocusOwner, onChange, onRemove, onKeyDown, }) {
    const value = useMemo(() => initialValue, [initialValue]);
    const removeButtonRef = useRef(null);
    const { hovered } = useDraggableItemContext();
    return (_jsxs("div", { style: { display: "flex", flexDirection: "row", justifyContent: "space-between" }, children: [typeHelper.component({
                autoFocus: true,
                onChange: (newValue) => onChange(newValue),
                id,
                isDisabled,
                style: {
                    borderColor: "transparent",
                    backgroundColor: "transparent",
                    outline: "none",
                },
                value,
                focusOwner,
                setFocusOwner,
                isValid,
                onKeyDown,
            }), _jsx(Button, { title: "Remove enum value", ref: removeButtonRef, style: { opacity: hovered ? "100%" : "0" }, isDisabled: isDisabled, className: "kie-dmn-editor--documentation-link--row-remove", variant: "plain", icon: _jsx(TimesIcon, {}), onClick: () => onRemove() }), hovered && _jsx(Tooltip, { content: "Remove", reference: removeButtonRef })] }));
}
export function isEnum(value, typeCheck) {
    if (value === undefined) {
        return undefined;
    }
    if (value === "") {
        return undefined;
    }
    const enumValues = value.split(ENUM_SEPARATOR).map((e) => e.trim());
    if (enumValues.reduce((isEnum, value) => isEnum && (typeCheck === null || typeCheck === void 0 ? void 0 : typeCheck(value)), true)) {
        return enumValues;
    }
    return undefined;
}
//# sourceMappingURL=ConstraintsEnum.js.map