import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useMemo, useEffect } from "react";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import "./Constraint.css";
export const REGEX_YEARS_MONTH_DURATION = /^P(?!$)((-)?\d+Y)?((-)?\d+M)?$/;
export function ConstraintYearsMonthsDuration({ id, value, onChange, focusOwner, setFocusOwner, isValid, isDisabled, }) {
    const years = useMemo(() => getYearsDuration(value), [value]);
    const months = useMemo(() => getMonthsDuration(value), [value]);
    useEffect(() => {
        var _a;
        if (focusOwner) {
            (_a = document.getElementById(focusOwner)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [focusOwner]);
    const onInternalChange = useCallback((args) => {
        var _a, _b, _c, _d;
        const y = ((_a = args.years) !== null && _a !== void 0 ? _a : years) ? ((_b = args.years) !== null && _b !== void 0 ? _b : years) + "Y" : "";
        const m = ((_c = args.months) !== null && _c !== void 0 ? _c : months) ? ((_d = args.months) !== null && _d !== void 0 ? _d : months) + "M" : "";
        const p = y || m ? "P" : "";
        onChange(`${p}${y}${m}`);
    }, [months, onChange, years]);
    const onYearsChange = useCallback((newValue, e) => {
        onInternalChange({ years: newValue });
        setFocusOwner === null || setFocusOwner === void 0 ? void 0 : setFocusOwner(e.currentTarget.id);
    }, [onInternalChange, setFocusOwner]);
    const onMonthsChange = useCallback((newValue, e) => {
        onInternalChange({ months: newValue });
        setFocusOwner === null || setFocusOwner === void 0 ? void 0 : setFocusOwner(e.currentTarget.id);
    }, [onInternalChange, setFocusOwner]);
    return (_jsx(_Fragment, { children: _jsxs("div", { style: { display: "flex", flexDirection: "row" }, children: [_jsxs("div", { style: { display: "flex", flexDirection: "row", alignItems: "center", justifyContent: "center" }, children: [_jsx("p", { children: "Y:" }), _jsx(TextInput, { id: `${id}-constraint-years`, type: "number", placeholder: "Years", style: { flex: "1 1 0px" }, className: `kie-dmn-editor--constraint-input ${isValid ? "" : "kie-dmn-editor--constraint-invalid"}`, value: years, onChange: onYearsChange, autoFocus: true, isDisabled: isDisabled })] }), _jsxs("div", { style: { display: "flex", flexDirection: "row", alignItems: "center", justifyContent: "center" }, children: [_jsx("p", { children: "M:" }), _jsx(TextInput, { id: `${id}-constraint-months`, type: "number", placeholder: "Months", style: { flex: "1 1 0px" }, className: `kie-dmn-editor--constraint-input ${isValid ? "" : "kie-dmn-editor--constraint-invalid"}`, value: months, onChange: onMonthsChange, isDisabled: isDisabled })] })] }) }));
}
function getYearsDuration(value) {
    if (!value.includes("Y")) {
        return "";
    }
    const years = value.replace("P", "").split("Y")[0];
    if (years.length >= 1) {
        return !isNaN(parseInt(years)) ? years : "";
    }
    return "";
}
function getMonthsDuration(value) {
    if (!value.includes("M")) {
        return "";
    }
    let months = value.replace("P", "").split("M")[0];
    if (value.includes("Y")) {
        months = months.split("Y")[1];
    }
    if (months.length >= 1) {
        return !isNaN(parseInt(months)) ? months : "";
    }
    return "";
}
//# sourceMappingURL=ConstraintYearsMonthsDuration.js.map