import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import "@patternfly/react-core/dist/styles/base.css";
import "reactflow/dist/style.css";
import * as React from "react";
import * as ReactDOM from "react-dom";
import * as RF from "reactflow";
import { ErrorBoundary } from "react-error-boundary";
import { useCallback, useEffect, useImperativeHandle, useMemo, useRef, useState } from "react";
import { original } from "immer";
import { normalize } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { FileIcon } from "@patternfly/react-icons/dist/js/icons/file-icon";
import { InfrastructureIcon } from "@patternfly/react-icons/dist/js/icons/infrastructure-icon";
import { PficonTemplateIcon } from "@patternfly/react-icons/dist/js/icons/pficon-template-icon";
import { Drawer, DrawerContent, DrawerContentBody } from "@patternfly/react-core/dist/js/components/Drawer";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Tab, TabTitleIcon, TabTitleText, Tabs } from "@patternfly/react-core/dist/js/components/Tabs";
import { BoxedExpressionScreen } from "./boxedExpressions/BoxedExpressionScreen";
import { DataTypes } from "./dataTypes/DataTypes";
import { Diagram } from "./diagram/Diagram";
import { DmnVersionLabel } from "./diagram/DmnVersionLabel";
import { BoxedExpressionPropertiesPanel } from "./propertiesPanel/BoxedExpressionPropertiesPanel";
import { DmnEditorContextProvider, useDmnEditor } from "./DmnEditorContext";
import { DmnEditorErrorFallback } from "./DmnEditorErrorFallback";
import { DmnEditorExternalModelsContextProvider, useExternalModels, } from "./includedModels/DmnEditorDependenciesContext";
import { IncludedModels } from "./includedModels/IncludedModels";
import { DiagramPropertiesPanel } from "./propertiesPanel/DiagramPropertiesPanel";
import { ComputedStateCache } from "./store/ComputedStateCache";
import { DmnEditorTab, createDmnEditorStore, defaultStaticState } from "./store/Store";
import { DmnEditorStoreApiContext, useDmnEditorStore, useDmnEditorStoreApi } from "./store/StoreContext";
import { DmnDiagramSvg } from "./svg/DmnDiagramSvg";
import { useEffectAfterFirstRender } from "./useEffectAfterFirstRender";
import { INITIAL_COMPUTED_CACHE } from "./store/computed/initial";
import "@kie-tools/dmn-marshaller/dist/kie-extensions";
import "./DmnEditor.css";
import { CommandsContextProvider, useCommands } from "./commands/CommandsContextProvider";
import { DmnEditorSettingsContextProvider } from "./settings/DmnEditorSettingsContext";
const ON_MODEL_CHANGE_DEBOUNCE_TIME_IN_MS = 500;
const SVG_PADDING = 20;
export const DmnEditorInternal = ({ model, originalVersion, onModelChange, onOpenedBoxedExpressionEditorNodeChange, onModelDebounceStateChanged, forwardRef, }) => {
    var _a, _b;
    const boxedExpressionEditorActiveDrgElementId = useDmnEditorStore((s) => s.boxedExpressionEditor.activeDrgElementId);
    const dmnEditorActiveTab = useDmnEditorStore((s) => s.navigation.tab);
    const isBeePropertiesPanelOpen = useDmnEditorStore((s) => s.boxedExpressionEditor.propertiesPanel.isOpen);
    const isDiagramPropertiesPanelOpen = useDmnEditorStore((s) => s.diagram.propertiesPanel.isOpen);
    const navigationTab = useDmnEditorStore((s) => s.navigation.tab);
    const dmn = useDmnEditorStore((s) => s.dmn);
    const isDiagramEditingInProgress = useDmnEditorStore((s) => s.computed(s).isDiagramEditingInProgress());
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { commandsRef } = useCommands();
    const { dmnModelBeforeEditingRef, dmnEditorRootElementRef } = useDmnEditor();
    const { externalModelsByNamespace } = useExternalModels();
    useEffect(() => {
        onOpenedBoxedExpressionEditorNodeChange === null || onOpenedBoxedExpressionEditorNodeChange === void 0 ? void 0 : onOpenedBoxedExpressionEditorNodeChange(dmnEditorActiveTab === DmnEditorTab.EDITOR ? boxedExpressionEditorActiveDrgElementId : undefined);
    }, [boxedExpressionEditorActiveDrgElementId, dmnEditorActiveTab, onOpenedBoxedExpressionEditorNodeChange]);
    const diagramRef = useRef(null);
    const diagramContainerRef = useRef(null);
    const beeContainerRef = useRef(null);
    useImperativeHandle(forwardRef, () => ({
        reset: (model) => {
            const state = dmnEditorStoreApi.getState();
            return state.dispatch(state).dmn.reset(normalize(model));
        },
        openBoxedExpressionEditor: (nodeId) => {
            dmnEditorStoreApi.setState((state) => {
                state.navigation.tab = DmnEditorTab.EDITOR;
                state.dispatch(state).boxedExpressionEditor.open(nodeId);
            });
        },
        getDiagramSvg: async () => {
            var _a, _b, _c, _d;
            const nodes = (_b = (_a = diagramRef.current) === null || _a === void 0 ? void 0 : _a.getReactFlowInstance()) === null || _b === void 0 ? void 0 : _b.getNodes();
            const edges = (_d = (_c = diagramRef.current) === null || _c === void 0 ? void 0 : _c.getReactFlowInstance()) === null || _d === void 0 ? void 0 : _d.getEdges();
            if (!nodes || !edges) {
                return undefined;
            }
            const bounds = RF.getNodesBounds(nodes);
            const state = dmnEditorStoreApi.getState();
            const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
            svg.setAttribute("width", bounds.width + SVG_PADDING * 2 + "");
            svg.setAttribute("height", bounds.height + (state.computed(state).isAlternativeInputDataShape() ? SVG_PADDING * 5 : SVG_PADDING * 2) + "");
            ReactDOM.render(_jsx("g", { transform: `translate(${-bounds.x + SVG_PADDING} ${-bounds.y + SVG_PADDING})`, children: _jsx(DmnDiagramSvg, { nodes: nodes, edges: edges, snapGrid: state.diagram.snapGrid, importsByNamespace: state.computed(state).importsByNamespace(), thisDmn: state.dmn, isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(), allDataTypesById: state.computed(state).getDataTypes(externalModelsByNamespace).allDataTypesById, allTopLevelItemDefinitionUniqueNames: state.computed(state).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames }) }), svg);
            return new XMLSerializer().serializeToString(svg);
        },
        getCommands: () => commandsRef.current,
    }), [dmnEditorStoreApi, externalModelsByNamespace, commandsRef]);
    useEffectAfterFirstRender(() => {
        dmnEditorStoreApi.setState((state) => {
            var _a;
            if (model === original(state.dmn.model)) {
                return;
            }
            state.diagram.autoLayout.canAutoGenerateDrd =
                ((_a = model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === undefined &&
                    model.definitions.drgElement !== undefined;
            state.dmn.model = normalize(model);
            dmnModelBeforeEditingRef.current = state.dmn.model;
        });
    }, [dmnEditorStoreApi, model]);
    useStateAsItWasBeforeConditionBecameTrue(dmn.model, isDiagramEditingInProgress, useCallback((prev) => (dmnModelBeforeEditingRef.current = prev), [dmnModelBeforeEditingRef]));
    useEffectAfterFirstRender(() => {
        if (isDiagramEditingInProgress) {
            return;
        }
        onModelDebounceStateChanged === null || onModelDebounceStateChanged === void 0 ? void 0 : onModelDebounceStateChanged(false);
        const timeout = setTimeout(() => {
            if (model === dmn.model) {
                return;
            }
            onModelDebounceStateChanged === null || onModelDebounceStateChanged === void 0 ? void 0 : onModelDebounceStateChanged(true);
            console.debug("DMN EDITOR: Model changed!");
            onModelChange === null || onModelChange === void 0 ? void 0 : onModelChange(dmn.model);
        }, ON_MODEL_CHANGE_DEBOUNCE_TIME_IN_MS);
        return () => {
            clearTimeout(timeout);
        };
    }, [isDiagramEditingInProgress, onModelChange, dmn.model]);
    const onTabChanged = useCallback((e, tab) => {
        dmnEditorStoreApi.setState((state) => {
            var _a, _b, _c;
            state.navigation.tab = tab;
            if (tab === DmnEditorTab.DATA_TYPES) {
                state.dataTypesEditor.activeItemDefinitionId =
                    (_a = state.dataTypesEditor.activeItemDefinitionId) !== null && _a !== void 0 ? _a : (_c = (_b = state.dmn.model.definitions.itemDefinition) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c["@_id"];
            }
        });
    }, [dmnEditorStoreApi]);
    const tabTitle = useMemo(() => {
        var _a, _b, _c, _d;
        return {
            editor: (_jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(PficonTemplateIcon, {}) }), _jsx(TabTitleText, { children: "Editor" })] })),
            dataTypes: (_jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(InfrastructureIcon, {}) }), _jsxs(TabTitleText, { children: ["Data types\u00A0\u00A0", _jsx(Label, { style: { padding: "0 12px" }, children: (_b = (_a = dmn.model.definitions.itemDefinition) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0 })] })] })),
            includedModels: (_jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(FileIcon, {}) }), _jsxs(TabTitleText, { children: ["Included models\u00A0\u00A0", _jsx(Label, { style: { padding: "0 12px" }, children: (_d = (_c = dmn.model.definitions.import) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0 })] })] })),
        };
    }, [(_a = dmn.model.definitions.import) === null || _a === void 0 ? void 0 : _a.length, (_b = dmn.model.definitions.itemDefinition) === null || _b === void 0 ? void 0 : _b.length]);
    const diagramPropertiesPanel = useMemo(() => _jsx(DiagramPropertiesPanel, {}), []);
    const beePropertiesPanel = useMemo(() => _jsx(BoxedExpressionPropertiesPanel, {}), []);
    return (_jsx("div", { ref: dmnEditorRootElementRef, className: "kie-dmn-editor--root", children: _jsxs(Tabs, { isFilled: true, activeKey: navigationTab, onSelect: onTabChanged, role: "region", className: "kie-dmn-editor--tabs", children: [_jsx(Tab, { eventKey: DmnEditorTab.EDITOR, title: tabTitle.editor, children: navigationTab === DmnEditorTab.EDITOR && (_jsxs(_Fragment, { children: [!boxedExpressionEditorActiveDrgElementId && (_jsx(Drawer, { isExpanded: isDiagramPropertiesPanelOpen, isInline: true, position: "right", children: _jsx(DrawerContent, { panelContent: diagramPropertiesPanel, children: _jsx(DrawerContentBody, { children: _jsxs("div", { className: "kie-tools--dmn-editor--diagram-container", ref: diagramContainerRef, "data-testid": "kie-tools--dmn-editor--diagram-container", children: [originalVersion && _jsx(DmnVersionLabel, { version: originalVersion }), _jsx(Diagram, { ref: diagramRef, container: diagramContainerRef })] }) }) }) })), boxedExpressionEditorActiveDrgElementId && (_jsx(Drawer, { isExpanded: isBeePropertiesPanelOpen, isInline: true, position: "right", children: _jsx(DrawerContent, { panelContent: beePropertiesPanel, children: _jsx(DrawerContentBody, { children: _jsx("div", { className: "kie-dmn-editor--bee-container", ref: beeContainerRef, children: _jsx(BoxedExpressionScreen, { container: beeContainerRef }) }) }) }) }))] })) }), _jsx(Tab, { eventKey: DmnEditorTab.DATA_TYPES, title: tabTitle.dataTypes, children: _jsx("div", { "data-testid": "kie-tools--dmn-editor--data-types-container", children: navigationTab === DmnEditorTab.DATA_TYPES && _jsx(DataTypes, {}) }) }), _jsx(Tab, { eventKey: DmnEditorTab.INCLUDED_MODELS, title: tabTitle.includedModels, children: _jsx("div", { "data-testid": "kie-tools--dmn-editor--included-models-container", children: navigationTab === DmnEditorTab.INCLUDED_MODELS && _jsx(IncludedModels, {}) }) })] }) }));
};
export const DmnEditor = React.forwardRef((props, ref) => {
    const store = useMemo(() => createDmnEditorStore(props.model, new ComputedStateCache(INITIAL_COMPUTED_CACHE)), []);
    const storeRef = React.useRef(store);
    const resetState = useCallback(({ args }) => {
        var _a;
        (_a = storeRef.current) === null || _a === void 0 ? void 0 : _a.setState((state) => {
            state.diagram = defaultStaticState().diagram;
            state.dmn.model = args[0];
        });
    }, []);
    return (_jsx(DmnEditorContextProvider, { ...props, children: _jsx(ErrorBoundary, { FallbackComponent: DmnEditorErrorFallback, onReset: resetState, children: _jsx(DmnEditorSettingsContextProvider, { ...props, children: _jsx(DmnEditorExternalModelsContextProvider, { ...props, children: _jsx(DmnEditorStoreApiContext.Provider, { value: storeRef.current, children: _jsx(CommandsContextProvider, { children: _jsx(DmnEditorInternal, { forwardRef: ref, ...props }) }) }) }) }) }) }));
});
export function usePrevious(value) {
    const [current, setCurrent] = useState(value);
    const [previous, setPrevious] = useState(value);
    if (value !== current) {
        setPrevious(current);
        setCurrent(value);
    }
    return previous;
}
export function useStateAsItWasBeforeConditionBecameTrue(state, condition, set) {
    const previous = usePrevious(state);
    useEffect(() => {
        if (condition) {
            console.debug("HOOK: `useStateBeforeCondition` --> ASSIGN");
            set(previous);
        }
    }, [condition, set]);
}
//# sourceMappingURL=DmnEditor.js.map