import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import { FormDmnValidator } from "./FormDmnValidator";
import { formDmnI18n } from "./i18n";
import { FormComponent } from "@kie-tools/form/dist/FormComponent";
import { DmnAutoFieldProvider } from "@kie-tools/dmn-runner/dist/uniforms";
import { formDmnRunnerAutoFieldValue } from "./uniforms/FormDmnRunnerAutoFieldValue";
export function FormDmn(props) {
    const i18n = useMemo(() => {
        var _a;
        formDmnI18n.setLocale((_a = props.locale) !== null && _a !== void 0 ? _a : navigator.language);
        return formDmnI18n.getCurrent();
    }, [props.locale]);
    const dmnValidator = useMemo(() => new FormDmnValidator(i18n), [i18n]);
    return (_jsx(FormComponent, { ...props, i18n: i18n, validator: dmnValidator, removeRequired: true, entryPath: "definitions.InputSet", propertiesEntryPath: "definitions.InputSet.properties", children: _jsx(DmnAutoFieldProvider, { value: formDmnRunnerAutoFieldValue }) }));
}
//# sourceMappingURL=FormDmn.js.map