import { jsx as _jsx } from "react/jsx-runtime";
import Moment from "react-moment";
import TaskDescription from "../TaskDescription/TaskDescription";
import { TaskState } from "../../../../taskDetails";
export const getDefaultColumn = (columnPath, columnLabel, isSortable) => {
    return {
        path: columnPath,
        label: columnLabel,
        isSortable,
    };
};
export const getDateColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => _jsx(Moment, { fromNow: true, children: new Date(`${value}`) }),
        isSortable: true,
    };
};
export const getTaskDescriptionColumn = (selectTask) => {
    return {
        label: "Name",
        path: "referenceName",
        bodyCellTransformer: (cellValue, rowTask) => {
            return (_jsx(TaskDescription, { task: rowTask, onClick: () => selectTask(rowTask) }));
        },
        isSortable: true,
    };
};
export const getTaskStateColumn = () => {
    return {
        label: "Status",
        path: "state",
        bodyCellTransformer: (cellValue, rowTask) => _jsx(TaskState, { task: rowTask }),
        isSortable: true,
    };
};
export const getDefaultTaskStates = () => {
    return ["Ready", "Reserved", "Completed", "Aborted", "Skipped"];
};
export const getDefaultActiveTaskStates = () => {
    return ["Ready", "Reserved"];
};
//# sourceMappingURL=TaskInboxUtils.js.map