import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Table, TableBody, TableHeader } from "@patternfly/react-table/dist/js/components/Table";
import { useCallback, useEffect, useState } from "react";
import { getProcessInstanceDescription, ProcessInstanceIconCreator } from "../utils/ProcessListUtils";
import { HistoryIcon } from "@patternfly/react-icons/dist/js/icons/history-icon";
import Moment from "react-moment";
import ProcessListActionsKebab from "../ProcessListActionsKebab/ProcessListActionsKebab";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import DisablePopup from "../DisablePopup/DisablePopup";
import ErrorPopover from "../ErrorPopover/ErrorPopover";
import "../styles.css";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import _ from "lodash";
const columnNames = ["__Select", "Id", "Status", "Created", "Last update", "__Actions"];
const ProcessListChildTable = ({ parentProcessId, selectedInstances, setSelectedInstances, processInstances, setProcessInstances, driver, onSkipClick, onRetryClick, onAbortClick, setSelectableInstances, singularProcessLabel, pluralProcessLabel, ouiaId, ouiaSafe, }) => {
    const [rows, setRows] = useState([]);
    const [isLoading, setIsLoading] = useState(false);
    const [showNoDataEmptyState, setShowNoDataEmptyState] = useState(false);
    const [error, setError] = useState();
    const columns = columnNames.map((it) => ({
        title: it.startsWith("__") ? "" : it,
    }));
    const handleClick = useCallback((childProcessInstance) => {
        driver.openProcess(childProcessInstance);
    }, [driver]);
    const checkBoxSelect = useCallback((processInstance) => {
        const clonedProcessInstances = [...processInstances];
        clonedProcessInstances.forEach((instance) => {
            var _a;
            if (instance.id === parentProcessId) {
                (_a = instance.childProcessInstances) === null || _a === void 0 ? void 0 : _a.forEach((childInstance) => {
                    if (childInstance.id === processInstance.id) {
                        if (childInstance.isSelected) {
                            childInstance.isSelected = false;
                            setSelectedInstances(selectedInstances.filter((selectedInstance) => selectedInstance.id !== childInstance.id));
                        }
                        else {
                            childInstance.isSelected = true;
                            setSelectedInstances([...selectedInstances, childInstance]);
                        }
                    }
                });
            }
        });
        setProcessInstances(clonedProcessInstances);
    }, [parentProcessId, processInstances, selectedInstances, setProcessInstances, setSelectedInstances]);
    const createRows = useCallback((childProcessInstances) => {
        if (!_.isEmpty(childProcessInstances)) {
            const tempRows = [];
            childProcessInstances.forEach((child) => {
                var _a;
                const cells = [
                    {
                        title: (_jsx(_Fragment, { children: ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) && child.serviceUrl !== null ? (_jsx(Checkbox, { isChecked: child.isSelected, onChange: () => {
                                    checkBoxSelect(child);
                                }, "aria-label": "process-list-checkbox", id: `checkbox-${child.id}`, name: `checkbox-${child.id}`, "data-testid": `checkbox-${child.id}` })) : (_jsx(DisablePopup, { processInstanceData: child, component: _jsx(Checkbox, { "aria-label": "process-list-checkbox-disabled", id: `checkbox-${child.id}`, isDisabled: true }) })) })),
                    },
                    {
                        title: (_jsxs(_Fragment, { children: [_jsx("a", { className: "kogito-process-list__link", onClick: () => handleClick(child), ...componentOuiaProps(ouiaId, "process-description", ouiaSafe), children: _jsx("strong", { children: _jsx(ItemDescriptor, { itemDescription: getProcessInstanceDescription(child) }) }) }), _jsx(EndpointLink, { serviceUrl: child.serviceUrl, isLinkShown: false })] })),
                    },
                    {
                        title: child.state === ProcessInstanceState.Error ? (_jsx(ErrorPopover, { processInstanceData: child, onSkipClick: onSkipClick, onRetryClick: onRetryClick })) : (ProcessInstanceIconCreator(child.state)),
                    },
                    {
                        title: child.start ? _jsx(Moment, { fromNow: true, children: new Date(`${child.start}`) }) : "",
                    },
                    {
                        title: child.lastUpdate ? (_jsxs("span", { children: [" ", _jsx(HistoryIcon, { className: "pf-u-mr-sm" }), " Updated", " ", _jsx(Moment, { fromNow: true, children: new Date(`${child.lastUpdate}`) })] })) : (""),
                    },
                    {
                        title: (_jsx(ProcessListActionsKebab, { processInstance: child, onSkipClick: onSkipClick, onRetryClick: onRetryClick, onAbortClick: onAbortClick }, child.id)),
                    },
                ];
                cells.forEach((cellInRow, index) => {
                    cellInRow.props = componentOuiaProps(columnNames[index].toLowerCase(), "process-list-cell", true);
                });
                tempRows.push({
                    cells: cells,
                });
            });
            setRows(tempRows);
            setShowNoDataEmptyState(false);
        }
        else {
            setShowNoDataEmptyState(true);
        }
    }, [checkBoxSelect, handleClick, onAbortClick, onRetryClick, onSkipClick, ouiaId, ouiaSafe]);
    const getChildProcessInstances = useCallback(async () => {
        try {
            setIsLoading(true);
            const response = await driver.getChildProcessesQuery(parentProcessId);
            processInstances.forEach((processInstance) => {
                if (processInstance.id === parentProcessId) {
                    response.forEach((child) => {
                        var _a;
                        child.isSelected = false;
                        if (child.serviceUrl && ((_a = child.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                            setSelectableInstances((prev) => prev + 1);
                        }
                    });
                    processInstance.childProcessInstances = response;
                }
            });
            createRows(response);
        }
        catch (error) {
            setError(error);
        }
        finally {
            setIsLoading(false);
        }
    }, [createRows, driver, parentProcessId, processInstances, setSelectableInstances]);
    useEffect(() => {
        if (processInstances.length > 0) {
            const processInstance = processInstances.find((instance) => instance.id === parentProcessId);
            processInstance && createRows(processInstance.childProcessInstances);
        }
    }, [createRows, parentProcessId, processInstances]);
    useEffect(() => {
        getChildProcessInstances();
    }, [getChildProcessInstances]);
    if (isLoading) {
        return _jsx(KogitoSpinner, { spinnerText: "Loading child instances..." });
    }
    if (error) {
        return _jsx(ServerErrors, { error: error, variant: "large" });
    }
    if (!isLoading && showNoDataEmptyState) {
        return (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Info, title: `No child ${singularProcessLabel.toLowerCase()} instances`, body: `This ${singularProcessLabel.toLowerCase()} has no related sub ${pluralProcessLabel.toLowerCase()}` }));
    }
    return (_jsxs(Table, { "aria-label": "Process List Child Table", cells: columns, rows: rows, variant: "compact", className: "kogito-management-console__compact-table", ...componentOuiaProps(ouiaId, "process-list-child-table", ouiaSafe ? ouiaSafe : !isLoading), children: [_jsx(TableHeader, {}), _jsx(TableBody, {})] }));
};
export default ProcessListChildTable;
//# sourceMappingURL=ProcessListChildTable.js.map