import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useState, useEffect, useCallback } from "react";
import { Table, TableHeader, TableBody, sortable, } from "@patternfly/react-table/dist/js/components/Table";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import Moment from "react-moment";
import _ from "lodash";
import { JobsIconCreator } from "../../../utils/utils";
import { HistoryIcon } from "@patternfly/react-icons/dist/js/icons/history-icon";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { constructObject, setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
const editableJobStatus = ["SCHEDULED", "ERROR"];
const JobsManagementTable = ({ jobs, driver, doQueryJobs, handleCancelModalToggle, handleDetailsToggle, handleRescheduleToggle, isActionPerformed, isLoading, setIsActionPerformed, selectedJobInstances, setModalTitle, setModalContent, setSelectedJobInstances, setSelectedJob, setSortBy, sortBy, setOrderBy, ouiaId, ouiaSafe, }) => {
    const [rows, setRows] = useState([]);
    const checkNotEmpty = useCallback(() => {
        return jobs && jobs.length > 0 && !isLoading;
    }, [jobs, isLoading]);
    const [columns, setColumns] = useState([
        { title: "Id" },
        { title: "Status" },
        { title: "Expiration time" },
        { title: "Retries" },
        { title: "Execution counter" },
        { title: "Last update" },
    ]);
    useEffect(() => {
        setColumns((currentColumns) => {
            return [...currentColumns].map((column) => {
                column["props"] = { className: "pf-u-text-align-center" };
                checkNotEmpty() && column.title !== "Id" ? (column["transforms"] = [sortable]) : "";
                return column;
            });
        });
    }, [checkNotEmpty]);
    const getValues = useCallback((job) => {
        const tempRows = [];
        let jobType = "";
        for (const item in job) {
            if (item === "id") {
                const ele = {
                    title: (_jsx(Tooltip, { content: job.id, children: _jsx("span", { children: job.id.substring(0, 7) }) })),
                };
                tempRows.push(ele);
            }
            else if (item === "status") {
                const ele = {
                    title: JobsIconCreator(job.status),
                };
                if (editableJobStatus.includes(job[item])) {
                    jobType = "Editable";
                }
                else {
                    jobType = "Non-editable";
                }
                tempRows.push(ele);
            }
            else if (item === "expirationTime") {
                const ele = {
                    title: (_jsx(React.Fragment, { children: job.expirationTime ? (_jsxs(_Fragment, { children: [" ", "expires in", " ", _jsx(Moment, { fromNow: true, ago: true, children: job.expirationTime })] })) : ("N/A") })),
                };
                tempRows.push(ele);
            }
            else if (item === "lastUpdate") {
                const ele = {
                    title: (_jsxs(_Fragment, { children: [_jsx(HistoryIcon, { className: "pf-u-mr-sm" }), " Updated ", _jsx(Moment, { fromNow: true, children: job.lastUpdate })] })),
                };
                tempRows.push(ele);
            }
            else {
                const ele = {
                    title: _jsx("span", { children: job[item] }),
                };
                tempRows.push(ele);
            }
        }
        return { tempRows, jobType };
    }, []);
    const onSelect = useCallback((_event, isSelected, rowId, _rowData) => {
        if (!checkNotEmpty()) {
            return;
        }
        setIsActionPerformed(false);
        setRows((currentRows) => {
            const copyOfRows = [...currentRows];
            if (rowId === -1) {
                copyOfRows.forEach((row) => {
                    row.selected = isSelected;
                    return row;
                });
                setSelectedJobInstances((currentSelectedJobInstances) => {
                    if (currentSelectedJobInstances.length === jobs.length) {
                        return [];
                    }
                    else if (currentSelectedJobInstances.length < jobs.length) {
                        return _.cloneDeep(jobs);
                    }
                    return currentSelectedJobInstances;
                });
            }
            else {
                if (copyOfRows[rowId]) {
                    copyOfRows[rowId].selected = isSelected;
                    const row = [...jobs].filter((job) => job.id === copyOfRows[rowId].rowKey);
                    setSelectedJobInstances((currentSelectedJobInstances) => {
                        const rowData = _.find(currentSelectedJobInstances, ["id", copyOfRows[rowId].rowKey]);
                        if (rowData === undefined) {
                            return [...currentSelectedJobInstances, row[0]];
                        }
                        else {
                            const copyOfSelectedJobInstances = [...currentSelectedJobInstances];
                            _.remove(copyOfSelectedJobInstances, (job) => job.id === copyOfRows[rowId].rowKey);
                            return copyOfSelectedJobInstances;
                        }
                    });
                }
            }
            return copyOfRows;
        });
    }, [checkNotEmpty, jobs, setIsActionPerformed, setSelectedJobInstances]);
    const tableContent = useCallback((jobs) => {
        const jobRow = [];
        if (!isLoading && !_.isEmpty(jobs)) {
            jobs.map((job) => {
                const retrievedValue = getValues(_.pick(job, ["id", "status", "expirationTime", "retries", "executionCounter", "lastUpdate"]));
                jobRow.push({
                    cells: retrievedValue.tempRows,
                    type: retrievedValue.jobType,
                    rowKey: job.id,
                    selected: false,
                });
            });
        }
        if (isLoading) {
            const tempRows = [
                {
                    rowKey: "1",
                    cells: [
                        {
                            props: { colSpan: 8 },
                            title: _jsx(KogitoSpinner, { spinnerText: "Loading jobs list..." }),
                        },
                    ],
                },
            ];
            setRows(tempRows);
        }
        else {
            if (jobRow.length === 0) {
                const tempRows = [
                    {
                        rowKey: "1",
                        cells: [
                            {
                                props: { colSpan: 8 },
                                title: (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" })),
                            },
                        ],
                    },
                ];
                setRows(tempRows);
            }
            else {
                setRows((prev) => [...prev, ...jobRow]);
            }
        }
    }, [getValues, isLoading]);
    const handleJobDetails = useCallback((id) => {
        const job = jobs.find((job) => job.id === id);
        setSelectedJob(job);
        handleDetailsToggle();
    }, [handleDetailsToggle, jobs, setSelectedJob]);
    const handleJobReschedule = useCallback((id) => {
        const job = jobs.find((job) => job.id === id);
        setSelectedJob(job);
        handleRescheduleToggle();
    }, [handleRescheduleToggle, jobs, setSelectedJob]);
    const handleCancelAction = useCallback(async (id) => {
        const job = jobs.find((job) => job.id === id);
        const cancelResponse = await driver.cancelJob(job);
        const title = setTitle(cancelResponse.modalTitle, "Job cancel");
        setModalTitle(title);
        setModalContent(cancelResponse.modalContent);
        handleCancelModalToggle();
    }, [driver, handleCancelModalToggle, jobs, setModalContent, setModalTitle]);
    const dynamicActions = useCallback((rowData) => {
        if (rowData.type === "Editable") {
            return [
                {
                    title: "Reschedule",
                    onClick: (_event, _rowId, rowData, _extra) => handleJobReschedule(rowData.rowKey),
                },
                {
                    title: "Cancel",
                    onClick: (_event, _rowId, rowData, _extra) => handleCancelAction(rowData.rowKey),
                },
            ];
        }
        else {
            return [];
        }
    }, [handleCancelAction, handleJobReschedule]);
    const actionResolver = useCallback((rowData) => {
        if (!checkNotEmpty()) {
            return [];
        }
        const editActions = dynamicActions(rowData);
        return [
            {
                title: "Details",
                onClick: (event, rowId, rowData, extra) => handleJobDetails(rowData.rowKey),
            },
            ...editActions,
        ];
    }, [checkNotEmpty, dynamicActions, handleJobDetails]);
    const onSort = useCallback(async (event, index, direction) => {
        setSortBy({ index, direction });
        let sortingColumn = event.target.innerText;
        sortingColumn = _.camelCase(sortingColumn);
        const obj = {};
        constructObject(obj, sortingColumn, direction.toUpperCase());
        setOrderBy(obj);
        await driver.sortBy(obj);
        await doQueryJobs(0, 10);
    }, [doQueryJobs, driver, setOrderBy, setSortBy]);
    useEffect(() => {
        if (isActionPerformed) {
            setSelectedJobInstances([]);
            setRows((curentRows) => {
                const updatedRows = curentRows.filter((row) => {
                    row.selected = false;
                    return row;
                });
                return updatedRows;
            });
        }
    }, [isActionPerformed, setSelectedJobInstances]);
    useEffect(() => {
        setRows([]);
        tableContent(jobs);
    }, [isLoading, jobs, tableContent]);
    return (_jsxs(Table, { cells: columns, rows: rows, onSelect: checkNotEmpty() ? onSelect : undefined, actionResolver: checkNotEmpty() ? actionResolver : undefined, sortBy: sortBy, onSort: onSort, "aria-label": "Jobs management Table", className: "kogito-jobs-management__table", ...componentOuiaProps(ouiaId, "jobs-management-table", ouiaSafe), children: [_jsx(TableHeader, {}), _jsx(TableBody, {})] }));
};
export default JobsManagementTable;
//# sourceMappingURL=JobsManagementTable.js.map